/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.tooling.api.AstGenerator;
import org.mule.tooling.api.AstValidatonResult;
import org.mule.tooling.api.ConfigurationException;
import org.mule.tooling.api.DynamicStructureException;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.packager.packaging.Classifier;
import org.mule.tools.api.packager.sources.MuleArtifactContentResolver;
import org.mule.tools.api.packager.sources.MuleContentGenerator;
import org.mule.tools.api.packager.structure.ProjectStructure;
import org.mule.tools.maven.mojo.AbstractMuleMojo;
import org.mule.tools.maven.mojo.model.lifecycle.MavenLifecyclePhase;

@Mojo(name="process-classes", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.TEST)
public class ProcessClassesMojo
extends AbstractMuleMojo {
    @Component
    private PluginDescriptor descriptor;
    private static final MuleVersion MIN_RUNTIME_AST_VERSION = new MuleVersion("4.4.0");
    private static final String MULE_POLICY = "mule-policy";
    private static final String MULE_DOMAIN = "mule-domain";
    private static final String SKIP_AST = "skipAST";
    private static final String SKIP_AST_VALIDATION = "skipASTValidation";

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        block8: {
            this.getLog().debug((CharSequence)"Generating process-classes code...");
            try {
                String skipAST = System.getProperty(SKIP_AST);
                if (!(skipAST != null && !skipAST.equals("false") || this.project.getPackaging().equals(MULE_POLICY) || this.hasDomain())) {
                    this.processAst();
                }
            }
            catch (IOException | IllegalArgumentException | ConfigurationException e) {
                throw new MojoFailureException("Fail to compile", e);
            }
            catch (NullPointerException e) {
                String className = "org.mule.runtime.config.internal.validation.AbstractErrorTypesValidation";
                String methodName = "isErrorTypePresent";
                if (e.getStackTrace().length > 1 && Objects.equals("org.mule.runtime.config.internal.validation.AbstractErrorTypesValidation", e.getStackTrace()[0].getClassName()) && Objects.equals("isErrorTypePresent", e.getStackTrace()[0].getMethodName())) break block8;
                throw new MojoFailureException("Fail to compile", (Throwable)e);
            }
        }
        try {
            this.getContentGenerator().copyDescriptorFile();
            if (!this.skipValidation) {
                this.getLog().debug((CharSequence)"executing validations in process-classes for Mule application");
                this.getProjectValidator().isProjectValid(MavenLifecyclePhase.VALIDATE.id());
            } else {
                this.getLog().debug((CharSequence)"Skipping process-classes validation for Mule application");
            }
        }
        catch (IOException | ValidationException e) {
            throw new MojoExecutionException("process-classes exception", (Exception)e);
        }
    }

    private void processAst() throws IOException, ConfigurationException, MojoExecutionException {
        ArtifactAst artifact;
        try {
            artifact = this.getArtifactAst();
        }
        catch (DynamicStructureException e) {
            this.getLog().warn((CharSequence)"The application has a dynamic structure based on properties available only at design time, so an artifact AST for it cannot be generated at this time. See previous WARN messages for where that dynamic structure is being detected.");
            return;
        }
        if (artifact != null) {
            ((MuleContentGenerator)this.getContentGenerator()).createAstFile(this.serialize(artifact));
        }
    }

    @Override
    public String getPreviousRunPlaceholder() {
        return "MULE_MAVEN_PLUGIN_PROCESS_CLASSES_PREVIOUS_RUN_PLACEHOLDER";
    }

    public ArtifactAst getArtifactAst() throws IOException, ConfigurationException, DynamicStructureException, MojoExecutionException {
        this.descriptor.getClassRealm().addURL(this.project.getBasedir().toPath().resolve("src").resolve("main").resolve("resources").toUri().toURL());
        MuleVersion appMinRuntimeVersion = new MuleVersion(this.getMuleApplicationModelLoader().getRuntimeVersion());
        MuleVersion runtimeVersion = appMinRuntimeVersion.newerThan(MIN_RUNTIME_AST_VERSION) ? appMinRuntimeVersion : MIN_RUNTIME_AST_VERSION;
        MuleArtifactContentResolver contentResolver = new MuleArtifactContentResolver(new ProjectStructure(this.projectBaseFolder.toPath(), false), this.getProjectInformation().getEffectivePom(), this.getProjectInformation().getProject().getBundleDependencies());
        AstGenerator astGenerator = new AstGenerator(this.getMavenClient(), runtimeVersion.toString(), this.project.getArtifacts(), Paths.get(this.project.getBuild().getDirectory(), new String[0]), this.descriptor.getClassRealm(), this.project.getDependencies(), Boolean.valueOf(contentResolver.isApplication()));
        ProjectStructure projectStructure = new ProjectStructure(this.projectBaseFolder.toPath(), false);
        ArtifactAst artifactAST = astGenerator.generateAST(contentResolver.getConfigs(), projectStructure.getConfigsPath());
        String skipASTValidation = System.getProperty(SKIP_AST_VALIDATION);
        if (artifactAST != null && !this.getClassifier().equalsIgnoreCase(Classifier.MULE_PLUGIN.toString()) && (skipASTValidation == null || skipASTValidation.equals("false"))) {
            AstValidatonResult validationResult = astGenerator.validateAST(artifactAST);
            for (ValidationResultItem warning : validationResult.getWarnings()) {
                this.getLog().warn((CharSequence)warning.getMessage());
            }
            if (!validationResult.getDynamicStructureErrors().isEmpty()) {
                for (ValidationResultItem dynamicStructureError : validationResult.getDynamicStructureErrors()) {
                    this.getLog().warn((CharSequence)dynamicStructureError.getMessage());
                }
                throw new DynamicStructureException();
            }
        }
        return artifactAST;
    }

    private boolean hasDomain() {
        if (this.project.getDependencies() != null) {
            for (Dependency dependency : this.project.getDependencies()) {
                if (dependency.getClassifier() == null || !dependency.getClassifier().equals(MULE_DOMAIN)) continue;
                return true;
            }
        }
        return false;
    }

    public InputStream serialize(ArtifactAst artifact) {
        return AstGenerator.serialize((ArtifactAst)artifact);
    }
}

