/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.module.analyze;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.mule.tools.maven.plugin.module.analyze.AnalyzerLogger;
import org.mule.tools.maven.plugin.module.analyze.ModuleApiAnalyzer;
import org.mule.tools.maven.plugin.module.analyze.ModuleApiAnalyzerException;
import org.mule.tools.maven.plugin.module.analyze.ProjectDependencyAnalysis;
import org.mule.tools.maven.plugin.module.analyze.SilentAnalyzerLogger;
import org.mule.tools.maven.plugin.module.analyze.VerboseAnalyzerLogger;

@Mojo(name="analyze", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class AnalyzeMojo
extends AbstractMojo
implements Contextualizable {
    public static final String NO_MODULE_API_PROBLEMS_FOUND = "No module API problems found";
    public static final String MODULE_API_PROBLEMS_FOUND = "Module API problems found";
    private Context context;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="muleModule.analyze.verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="muleModule.analyze.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping pom project");
            return;
        }
        boolean error = this.checkDependencies();
        if (error) {
            throw new MojoExecutionException(MODULE_API_PROBLEMS_FOUND);
        }
    }

    protected ModuleApiAnalyzer createProjectDependencyAnalyzer() throws MojoExecutionException {
        String role = ModuleApiAnalyzer.ROLE;
        String roleHint = "default";
        try {
            PlexusContainer container = (PlexusContainer)this.context.get((Object)"plexus");
            return (ModuleApiAnalyzer)container.lookup(role, "default");
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Failed to instantiate ModuleApiAnalyzer with role " + role + " / role-hint " + "default", exception);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    private boolean checkDependencies() throws MojoExecutionException {
        ProjectDependencyAnalysis analysis;
        try {
            AnalyzerLogger analyzerLogger = this.verbose ? new VerboseAnalyzerLogger(this.getLog()) : new SilentAnalyzerLogger();
            analysis = this.createProjectDependencyAnalyzer().analyze(this.project, analyzerLogger);
        }
        catch (ModuleApiAnalyzerException exception) {
            throw new MojoExecutionException("Cannot analyze module API", (Exception)exception);
        }
        HashMap<String, Set<String>> undeclaredExportedPackages = new HashMap<String, Set<String>>(analysis.getUndeclaredPackageDeps());
        HashSet<String> packagesToExport = new HashSet<String>(analysis.getPackagesToExport());
        boolean reported = false;
        boolean warning = false;
        if (!undeclaredExportedPackages.isEmpty()) {
            this.getLog().info((CharSequence)"Used undeclared exported packages found:");
            if (this.verbose) {
                this.logUnExportedDependenciesPerPackage(analysis.getUndeclaredPackageDeps());
            }
            reported = true;
            warning = true;
        }
        if (!packagesToExport.isEmpty()) {
            this.logPackagesToExport(packagesToExport);
            reported = true;
            warning = true;
        }
        if (!reported) {
            this.getLog().info((CharSequence)NO_MODULE_API_PROBLEMS_FOUND);
        }
        return warning;
    }

    private void logUnExportedDependenciesPerPackage(Map<String, Set<String>> artifacts) {
        if (artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"   None");
        } else {
            for (String exportedPackageName : artifacts.keySet()) {
                StringBuilder builder = new StringBuilder();
                builder.append("Undeclared exported packages for ").append(exportedPackageName).append(":\n");
                Set<String> undeclaredExportedPackages = artifacts.get(exportedPackageName);
                if (undeclaredExportedPackages == null || undeclaredExportedPackages.isEmpty()) {
                    builder.append("NONE");
                    continue;
                }
                for (String undeclaredExportedPackage : undeclaredExportedPackages) {
                    builder.append(undeclaredExportedPackage).append("\n");
                }
                this.getLog().info((CharSequence)builder.toString());
            }
        }
    }

    private void logPackagesToExport(Set<String> packageNames) {
        StringBuilder builder = new StringBuilder();
        builder.append("Packages that must be exported:\n");
        if (packageNames.isEmpty()) {
            builder.append("   NONE");
        } else {
            for (String packageName : packageNames) {
                builder.append(packageName).append("\n");
            }
        }
        this.getLog().info((CharSequence)builder.toString());
    }
}

