/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.module.analyze;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.mule.tools.maven.plugin.module.analyze.AnalyzerLogger;
import org.mule.tools.maven.plugin.module.analyze.DependencyAnalyzer;
import org.mule.tools.maven.plugin.module.analyze.ModuleApiAnalyzer;
import org.mule.tools.maven.plugin.module.analyze.ModuleApiAnalyzerException;
import org.mule.tools.maven.plugin.module.analyze.ProjectDependencyAnalysis;

@Component(role=ModuleApiAnalyzer.class)
public class DefaultModuleApiAnalyzer
implements ModuleApiAnalyzer {
    private static final char PACKAGE_SEPARATOR = '.';
    private static final String EMPTY_PACKAGE = "";
    @Requirement
    private DependencyAnalyzer dependencyAnalyzer;

    public static String getPackageName(String className) {
        return className.lastIndexOf(46) < 0 ? EMPTY_PACKAGE : className.substring(0, className.lastIndexOf(46));
    }

    @Override
    public ProjectDependencyAnalysis analyze(MavenProject project, AnalyzerLogger analyzerLogger) throws ModuleApiAnalyzerException {
        Properties properties = this.getModuleProperties(project);
        if (properties == null) {
            analyzerLogger.log("Project is not a mule module");
            return new ProjectDependencyAnalysis();
        }
        try {
            Set<String> projectExportedPackages = this.getModuleExportedPackages(analyzerLogger, properties);
            Set<String> externalExportedPackages = this.discoverExternalExportedPackages(project, analyzerLogger, (String)properties.get("module.name"));
            Map<String, Set<String>> projectPackageDependencies = this.findPackageDependencies(project, analyzerLogger);
            HashMap<String, Set<String>> missingExportedPackages = new HashMap<String, Set<String>>();
            for (String projectExportedPackage : projectExportedPackages) {
                Set<String> packageDeps = projectPackageDependencies.get(projectExportedPackage);
                if (packageDeps == null) continue;
                packageDeps.removeAll(projectExportedPackages);
                packageDeps.removeAll(externalExportedPackages);
                if (packageDeps.isEmpty()) continue;
                HashSet<String> packageToExport = new HashSet<String>();
                for (String packageDep : packageDeps) {
                    if (externalExportedPackages.contains(packageDep)) continue;
                    packageToExport.add(packageDep);
                }
                if (packageToExport.isEmpty()) continue;
                analyzerLogger.log("Missing export packages: " + packageDeps);
                missingExportedPackages.put(projectExportedPackage, packageDeps);
            }
            if (!missingExportedPackages.isEmpty()) {
                boolean dirty;
                Map<String, Set<String>> externalPackageDeps = this.calculateExternalDeps(project, analyzerLogger);
                do {
                    dirty = false;
                    for (String missingExportedPackage : new HashSet(missingExportedPackages.keySet())) {
                        Set missingExportedPackageDeps = (Set)missingExportedPackages.get(missingExportedPackage);
                        for (String missingExportedPackageDep : missingExportedPackageDeps) {
                            Set<String> packagesToAdd = externalPackageDeps.get(missingExportedPackageDep);
                            if (packagesToAdd == null || packagesToAdd.isEmpty()) continue;
                            HashSet<String> currentNoExportedPackageDeps = (HashSet<String>)missingExportedPackages.get(missingExportedPackageDep);
                            if (currentNoExportedPackageDeps == null) {
                                currentNoExportedPackageDeps = new HashSet<String>();
                                missingExportedPackages.put(missingExportedPackageDep, currentNoExportedPackageDeps);
                            }
                            for (String packageToAdd : packagesToAdd) {
                                if (externalExportedPackages.contains(packageToAdd) || !currentNoExportedPackageDeps.add(packageToAdd)) continue;
                                dirty = true;
                            }
                        }
                    }
                } while (dirty);
            }
            HashSet<String> packagesToExport = new HashSet<String>();
            for (Set<String> packageDeps : missingExportedPackages.keySet()) {
                packagesToExport.addAll((Collection)missingExportedPackages.get(packageDeps));
            }
            return new ProjectDependencyAnalysis(missingExportedPackages, packagesToExport);
        }
        catch (Exception exception) {
            throw new ModuleApiAnalyzerException("Cannot analyze dependencies", exception);
        }
    }

    private Properties getModuleProperties(MavenProject project) throws ModuleApiAnalyzerException {
        Properties properties = null;
        try {
            File moduleProperties;
            List projectResources = project.getBuild().getResources();
            File result = null;
            for (int i = 0; i < projectResources.size(); ++i) {
                Resource resource = (Resource)projectResources.get(i);
                File moduleProperties1 = new File(resource.getDirectory(), "META-INF" + File.separator + "mule-module.properties");
                if (!moduleProperties1.exists()) continue;
                result = moduleProperties1;
                break;
            }
            if ((moduleProperties = result) != null) {
                properties = this.loadProperties(moduleProperties.toURI().toURL());
            }
        }
        catch (IOException e) {
            throw new ModuleApiAnalyzerException("Cannot access module properties", e);
        }
        return properties;
    }

    private Set<String> discoverExternalExportedPackages(MavenProject project, AnalyzerLogger analyzerLogger, String projectModuleName) throws ModuleApiAnalyzerException {
        HashSet<String> result = new HashSet<String>();
        HashSet<URL> urls = new HashSet<URL>();
        List elements = null;
        try {
            elements = project.getRuntimeClasspathElements();
            elements.addAll(project.getCompileClasspathElements());
            for (String element : elements) {
                urls.add(new File(element).toURI().toURL());
            }
            URLClassLoader contextClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
            try {
                Enumeration<URL> resources = contextClassLoader.getResources("META-INF/mule-module.properties");
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    Properties properties = this.loadProperties(url);
                    if (properties.get("module.name").equals(projectModuleName)) continue;
                    Set<String> modulePackages = this.getModuleExportedPackages(analyzerLogger, properties);
                    result.addAll(modulePackages);
                }
            }
            catch (Exception e) {
                throw new ModuleApiAnalyzerException("Cannot read mule-module.properties", e);
            }
        }
        catch (Exception e) {
            throw new ModuleApiAnalyzerException("Error getting project resources", e);
        }
        return result;
    }

    private Set<String> getModuleExportedPackages(AnalyzerLogger analyzerLogger, Properties properties) throws IOException {
        HashSet<String> modulePackages = new HashSet<String>();
        String classPackages = (String)properties.get("artifact.export.classPackages");
        StringBuilder builder = new StringBuilder("Found module: " + properties.get("module.name") + " exporting:");
        for (String classPackage : classPackages.split(",")) {
            if (classPackage == null || (classPackage = classPackage.trim()) == null) continue;
            modulePackages.add(classPackage);
            builder.append("\n").append(classPackage);
        }
        analyzerLogger.log(builder.toString());
        return modulePackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(URL url) throws IOException {
        Properties properties = new Properties();
        try (InputStream resourceStream = null;){
            resourceStream = url.openStream();
            properties.load(resourceStream);
        }
        return properties;
    }

    private Map<String, Set<String>> calculateExternalDeps(MavenProject project, AnalyzerLogger analyzerLogger) throws IOException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Object projectArtifact : project.getArtifacts()) {
            Artifact artifact = (Artifact)projectArtifact;
            if ("test".equals(artifact.getScope())) {
                analyzerLogger.log("Skipping test artifact: " + artifact.getFile().toString());
                continue;
            }
            Map<String, Set<String>> artifactExternalPackageDeps = this.findPackageDependencies(artifact.getFile().toString(), analyzerLogger);
            for (String externalPackageName : artifactExternalPackageDeps.keySet()) {
                Set<String> packageDeps = artifactExternalPackageDeps.get(externalPackageName);
                if (packageDeps == null || packageDeps.isEmpty()) continue;
                HashSet<String> externalPackageDeps = (HashSet<String>)result.get(externalPackageName);
                if (externalPackageDeps == null) {
                    externalPackageDeps = new HashSet<String>();
                    result.put(externalPackageName, externalPackageDeps);
                }
                externalPackageDeps.addAll(packageDeps);
            }
        }
        return result;
    }

    protected Map<String, Set<String>> findPackageDependencies(MavenProject project, AnalyzerLogger analyzerLogger) throws IOException {
        String outputDirectory = project.getBuild().getOutputDirectory();
        Map<String, Set<String>> packageDeps = this.findPackageDependencies(outputDirectory, analyzerLogger);
        return packageDeps;
    }

    private Map<String, Set<String>> findPackageDependencies(String path, AnalyzerLogger analyzerLogger) throws IOException {
        URL url = new File(path).toURI().toURL();
        return this.dependencyAnalyzer.analyze(url, analyzerLogger);
    }
}

