/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.module.analyze;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ProjectDependencyAnalysis {
    private final Map<String, Set<String>> undeclaredPackageDeps;
    private final Set<String> packagesToExport;

    public ProjectDependencyAnalysis() {
        this(new HashMap<String, Set<String>>(), new HashSet<String>());
    }

    public ProjectDependencyAnalysis(Map<String, Set<String>> undeclaredPackageDeps, Set<String> packagesToExport) {
        this.undeclaredPackageDeps = undeclaredPackageDeps;
        this.packagesToExport = packagesToExport;
    }

    public Map<String, Set<String>> getUndeclaredPackageDeps() {
        return this.undeclaredPackageDeps;
    }

    public Set<String> getPackagesToExport() {
        return this.packagesToExport;
    }

    public int hashCode() {
        int hashCode = this.getUndeclaredPackageDeps().hashCode();
        hashCode = hashCode * 37 + this.getPackagesToExport().hashCode();
        return hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof ProjectDependencyAnalysis) {
            ProjectDependencyAnalysis analysis = (ProjectDependencyAnalysis)object;
            return this.getUndeclaredPackageDeps().equals(analysis.getUndeclaredPackageDeps()) && this.getPackagesToExport().equals(analysis.getPackagesToExport());
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (!this.getUndeclaredPackageDeps().isEmpty()) {
            buffer.append("undeclaredPackagesDeps=").append(this.getUndeclaredPackageDeps());
        }
        if (!this.getPackagesToExport().isEmpty()) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append("packagesToExport=").append(this.getPackagesToExport());
        }
        buffer.insert(0, "[");
        buffer.insert(0, this.getClass().getName());
        buffer.append("]");
        return buffer.toString();
    }

    private Set<String> safeCopy(Set<String> set) {
        return set == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<String>(set));
    }
}

