/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.module.analyze;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.mule.tools.maven.plugin.module.analyze.AnalyzerLogger;
import org.mule.tools.maven.plugin.module.analyze.DependencyAnalyzer;
import org.mule.tools.maven.plugin.module.analyze.JrePackageFinder;
import org.mule.tools.maven.plugin.module.analyze.ModuleApiAnalyzer;
import org.mule.tools.maven.plugin.module.analyze.ModuleApiAnalyzerException;
import org.mule.tools.maven.plugin.module.analyze.ProjectDependencyAnalysis;

@Component(role=ModuleApiAnalyzer.class)
public class DefaultModuleApiAnalyzer
implements ModuleApiAnalyzer {
    public static final String PROJECT_IS_NOT_A_MULE_MODULE = "Project is not a mule module";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final String EMPTY_PACKAGE = "";
    @Requirement
    private DependencyAnalyzer dependencyAnalyzer;

    public static String getPackageName(String className) {
        return className.lastIndexOf(46) < 0 ? EMPTY_PACKAGE : className.substring(0, className.lastIndexOf(46));
    }

    @Override
    public ProjectDependencyAnalysis analyze(MavenProject project, AnalyzerLogger analyzerLogger) throws ModuleApiAnalyzerException {
        Properties properties = this.getModuleProperties(project);
        if (properties == null) {
            analyzerLogger.log(PROJECT_IS_NOT_A_MULE_MODULE);
            return new ProjectDependencyAnalysis();
        }
        try {
            HashSet<String> diff;
            boolean dirty;
            Set<String> projectExportedPackages = this.getModuleExportedPackages(analyzerLogger, properties);
            Set<String> projectOptionalPackages = this.getModuleOptionalPackages(analyzerLogger, properties);
            this.checkExportedOptionalPackage(analyzerLogger, projectExportedPackages, projectOptionalPackages);
            Set<String> externalExportedPackages = this.discoverExternalExportedPackages(project, analyzerLogger, (String)properties.get("module.name"));
            this.removeExternalModuleExportedPackage(analyzerLogger, projectExportedPackages, externalExportedPackages);
            Map<String, Set<String>> projectPackageDependencies = this.findPackageDependencies(project, analyzerLogger);
            HashMap<String, Set<String>> missingExportedPackages = new HashMap<String, Set<String>>();
            Map<String, Set<String>> externalPackageDeps = this.calculateExternalDeps(project, analyzerLogger);
            HashSet<String> exportedPackageClosure = new HashSet<String>(projectExportedPackages);
            HashSet<String> missingAnalyzedPackages = new HashSet<String>();
            Set<String> jrePackages = JrePackageFinder.find();
            do {
                diff = new HashSet<String>();
                HashSet exportedByOtherModule = new HashSet();
                for (String exportedPackage : exportedPackageClosure) {
                    if (this.ignorePackage(analyzerLogger, exportedPackage, jrePackages, externalExportedPackages)) continue;
                    Set<String> packageDeps = projectPackageDependencies.get(exportedPackage);
                    if (packageDeps != null) {
                        for (String packageDep : packageDeps) {
                            if (exportedPackageClosure.contains(packageDep) || this.ignorePackage(analyzerLogger, packageDep, jrePackages, externalExportedPackages)) continue;
                            diff.add(packageDep);
                        }
                        continue;
                    }
                    packageDeps = externalPackageDeps.get(exportedPackage);
                    if (packageDeps != null) {
                        for (String packageDep : packageDeps) {
                            if (exportedPackageClosure.contains(packageDep) || this.ignorePackage(analyzerLogger, packageDep, jrePackages, externalExportedPackages)) continue;
                            diff.add(packageDep);
                        }
                        continue;
                    }
                    if (externalExportedPackages.contains(exportedPackage) || projectOptionalPackages.contains(exportedPackage)) continue;
                    missingAnalyzedPackages.add(exportedPackage);
                }
                exportedPackageClosure.addAll(diff);
                exportedPackageClosure.removeAll(exportedByOtherModule);
                diff.removeAll(exportedByOtherModule);
            } while (dirty = !diff.isEmpty());
            StringBuilder builder = new StringBuilder("Exported package closure:");
            for (String exportedPackage : exportedPackageClosure) {
                builder.append("\n").append(exportedPackage);
            }
            analyzerLogger.log(builder.toString());
            HashSet<String> packagesToExport = new HashSet<String>(exportedPackageClosure);
            packagesToExport.removeAll(projectExportedPackages);
            packagesToExport.removeAll(projectOptionalPackages);
            return new ProjectDependencyAnalysis(missingExportedPackages, packagesToExport, missingAnalyzedPackages);
        }
        catch (Exception exception) {
            throw new ModuleApiAnalyzerException("Cannot analyze dependencies", exception);
        }
    }

    private void checkExportedOptionalPackage(AnalyzerLogger analyzerLogger, Set<String> projectExportedPackages, Set<String> projectOptionalPackages) throws ModuleApiAnalyzerException {
        ArrayList<String> packages = new ArrayList<String>();
        for (String projectOptionalPackage : projectOptionalPackages) {
            if (!projectExportedPackages.contains(projectOptionalPackage)) continue;
            packages.add(projectOptionalPackage);
        }
        if (!packages.isEmpty()) {
            String message = DefaultModuleApiAnalyzer.buildOptionalPackageExportedMessage(packages);
            analyzerLogger.log(message);
            throw new ModuleApiAnalyzerException(message);
        }
    }

    private void removeExternalModuleExportedPackage(AnalyzerLogger analyzerLogger, Set<String> projectExportedPackages, Set<String> externalExportedPackages) {
        for (String externalExportedPackage : externalExportedPackages) {
            if (!projectExportedPackages.contains(externalExportedPackage)) continue;
            analyzerLogger.log(DefaultModuleApiAnalyzer.buildRedundantExportedPackageMessage(externalExportedPackage));
            projectExportedPackages.remove(externalExportedPackage);
        }
    }

    public static String buildOptionalPackageExportedMessage(List<String> packages) {
        return "Module exports packages defined as optional: " + packages;
    }

    public static String buildRedundantExportedPackageMessage(String packageName) {
        return "Exported package '" + packageName + "' already exported by a module dependency";
    }

    public static String buildRemovedProvidedPackageMessage(String packageName) {
        return "Package " + packageName + " already exported by a module dependency. Removing from export package closure";
    }

    public static String buildRemovedSunPackageMessage(String packageName) {
        return "Removing internal SUN package " + packageName + " from export package closure";
    }

    public static String buildRemovedJrePackageMessage(String packageName) {
        return "Removing JRE package " + packageName + " from export package closure";
    }

    private boolean ignorePackage(AnalyzerLogger analyzerLogger, String packageName, Set<String> jrePackages, Set<String> otherModuleExportedPackages) {
        boolean result = false;
        if (otherModuleExportedPackages.contains(packageName)) {
            analyzerLogger.log(DefaultModuleApiAnalyzer.buildRemovedProvidedPackageMessage(packageName));
            result = true;
        } else if (jrePackages.contains(packageName)) {
            analyzerLogger.log(DefaultModuleApiAnalyzer.buildRemovedJrePackageMessage(packageName));
            result = true;
        } else if (packageName.startsWith("sun.") || packageName.startsWith("com.sun.")) {
            analyzerLogger.log(DefaultModuleApiAnalyzer.buildRemovedSunPackageMessage(packageName));
            result = true;
        }
        return result;
    }

    private Properties getModuleProperties(MavenProject project) throws ModuleApiAnalyzerException {
        Properties properties = null;
        try {
            File moduleProperties;
            List projectResources = project.getBuild().getResources();
            File result = null;
            for (int i = 0; i < projectResources.size(); ++i) {
                Resource resource = (Resource)projectResources.get(i);
                File moduleProperties1 = new File(resource.getDirectory(), "META-INF" + File.separator + "mule-module.properties");
                if (!moduleProperties1.exists()) continue;
                result = moduleProperties1;
                break;
            }
            if ((moduleProperties = result) != null) {
                properties = this.loadProperties(moduleProperties.toURI().toURL());
            }
        }
        catch (IOException e) {
            throw new ModuleApiAnalyzerException("Cannot access module properties", e);
        }
        return properties;
    }

    private Set<String> discoverExternalExportedPackages(MavenProject project, AnalyzerLogger analyzerLogger, String projectModuleName) throws ModuleApiAnalyzerException {
        HashSet<String> result = new HashSet<String>();
        HashSet<URL> urls = new HashSet<URL>();
        try {
            List elements = project.getRuntimeClasspathElements();
            elements.addAll(project.getCompileClasspathElements());
            for (String element : elements) {
                urls.add(new File(element).toURI().toURL());
            }
            URLClassLoader contextClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
            try {
                Enumeration<URL> resources = contextClassLoader.getResources("META-INF/mule-module.properties");
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    Properties properties = this.loadProperties(url);
                    if (properties.get("module.name").equals(projectModuleName)) continue;
                    Set<String> modulePackages = this.getModuleExportedPackages(analyzerLogger, properties);
                    result.addAll(modulePackages);
                }
            }
            catch (Exception e) {
                throw new ModuleApiAnalyzerException("Cannot read mule-module.properties", e);
            }
        }
        catch (Exception e) {
            throw new ModuleApiAnalyzerException("Error getting project resources", e);
        }
        return result;
    }

    private Set<String> getModuleExportedPackages(AnalyzerLogger analyzerLogger, Properties properties) throws IOException {
        return this.getModulePackagesFromProperty(analyzerLogger, properties, "artifact.export.classPackages");
    }

    private Set<String> getModuleOptionalPackages(AnalyzerLogger analyzerLogger, Properties properties) throws IOException {
        return this.getModulePackagesFromProperty(analyzerLogger, properties, "artifact.export.optionalPackages");
    }

    private Set<String> getModulePackagesFromProperty(AnalyzerLogger analyzerLogger, Properties properties, String key) {
        HashSet<String> optionalPackages = new HashSet<String>();
        String classPackages = (String)properties.get(key);
        if (classPackages != null) {
            StringBuilder builder = new StringBuilder("Found module: " + properties.get("module.name") + " with property=" + key + ":");
            for (String classPackage : classPackages.split(",")) {
                if (classPackage == null || (classPackage = classPackage.trim()) == null) continue;
                optionalPackages.add(classPackage);
                builder.append("\n").append(classPackage);
            }
            analyzerLogger.log(builder.toString());
        }
        return optionalPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(URL url) throws IOException {
        Properties properties = new Properties();
        try (InputStream resourceStream = null;){
            resourceStream = url.openStream();
            properties.load(resourceStream);
        }
        return properties;
    }

    private Map<String, Set<String>> calculateExternalDeps(MavenProject project, AnalyzerLogger analyzerLogger) throws IOException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Object projectArtifact : project.getArtifacts()) {
            Artifact artifact = (Artifact)projectArtifact;
            if ("test".equals(artifact.getScope())) {
                analyzerLogger.log("Skipping test artifact: " + artifact.getFile().toString());
                continue;
            }
            Map<String, Set<String>> artifactExternalPackageDeps = this.findPackageDependencies(artifact.getFile().toString(), analyzerLogger);
            for (String externalPackageName : artifactExternalPackageDeps.keySet()) {
                Set<String> packageDeps = artifactExternalPackageDeps.get(externalPackageName);
                HashSet<String> externalPackageDeps = (HashSet<String>)result.get(externalPackageName);
                if (externalPackageDeps == null) {
                    externalPackageDeps = new HashSet<String>();
                    result.put(externalPackageName, externalPackageDeps);
                }
                externalPackageDeps.addAll(packageDeps);
            }
        }
        return result;
    }

    protected Map<String, Set<String>> findPackageDependencies(MavenProject project, AnalyzerLogger analyzerLogger) throws IOException {
        String outputDirectory = project.getBuild().getOutputDirectory();
        Map<String, Set<String>> packageDeps = this.findPackageDependencies(outputDirectory, analyzerLogger);
        return packageDeps;
    }

    private Map<String, Set<String>> findPackageDependencies(String path, AnalyzerLogger analyzerLogger) throws IOException {
        URL url = new File(path).toURI().toURL();
        return this.dependencyAnalyzer.analyze(url, analyzerLogger);
    }
}

