/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.module.analyze;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.mule.tools.maven.plugin.module.analyze.AnalyzerLogger;
import org.mule.tools.maven.plugin.module.analyze.Module;
import org.mule.tools.maven.plugin.module.analyze.ModuleApiAnalyzerException;
import org.mule.tools.maven.plugin.module.analyze.ModuleFactory;

public class ModuleDiscoverer {
    private static final String MULE_MODULE_PROPERTIES = "mule-module.properties";
    private static final String MULE_MODULE_PROPERTIES_LOCATION = "META-INF" + File.separator + "mule-module.properties";
    private final ModuleFactory moduleFactory = new ModuleFactory();

    public Module discoverProjectModule(MavenProject project, AnalyzerLogger analyzerLogger) throws ModuleApiAnalyzerException {
        Module module = null;
        Properties properties = this.getModuleProperties(project);
        if (properties != null) {
            try {
                module = this.moduleFactory.create(analyzerLogger, (String)properties.get("module.name"), properties);
            }
            catch (IOException e) {
                throw new ModuleApiAnalyzerException("Cannot read project's mule-module.properties", e);
            }
        }
        return module;
    }

    public List<Module> discoverExternalModules(MavenProject project, AnalyzerLogger analyzerLogger, String projectModuleName) throws ModuleApiAnalyzerException {
        LinkedList<Module> result = new LinkedList<Module>();
        HashSet<URL> urls = new HashSet<URL>();
        try {
            List elements = project.getRuntimeClasspathElements();
            elements.addAll(project.getCompileClasspathElements());
            for (String element : elements) {
                urls.add(new File(element).toURI().toURL());
            }
            URLClassLoader contextClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
            try {
                Enumeration<URL> resources = contextClassLoader.getResources(MULE_MODULE_PROPERTIES_LOCATION);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    Properties properties = this.loadProperties(url);
                    String moduleName = (String)properties.get("module.name");
                    if (moduleName.equals(projectModuleName)) continue;
                    result.add(this.moduleFactory.create(analyzerLogger, moduleName, properties));
                }
            }
            catch (Exception e) {
                throw new ModuleApiAnalyzerException("Cannot read " + MULE_MODULE_PROPERTIES_LOCATION, e);
            }
        }
        catch (Exception e) {
            throw new ModuleApiAnalyzerException("Error getting project resources", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(URL url) throws IOException {
        Properties properties = new Properties();
        try (InputStream resourceStream = null;){
            resourceStream = url.openStream();
            properties.load(resourceStream);
        }
        return properties;
    }

    private Properties getModuleProperties(MavenProject project) throws ModuleApiAnalyzerException {
        Properties properties = null;
        try {
            File moduleProperties;
            List projectResources = project.getBuild().getResources();
            File result = null;
            for (int i = 0; i < projectResources.size(); ++i) {
                Resource resource = (Resource)projectResources.get(i);
                File moduleProperties2 = new File(resource.getDirectory(), MULE_MODULE_PROPERTIES_LOCATION);
                if (!moduleProperties2.exists()) continue;
                result = moduleProperties2;
                break;
            }
            if ((moduleProperties = result) != null) {
                properties = this.loadProperties(moduleProperties.toURI().toURL());
            }
        }
        catch (IOException e) {
            throw new ModuleApiAnalyzerException("Cannot access module properties", e);
        }
        return properties;
    }
}

