/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.module.analyze.asm;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.mule.tools.maven.plugin.module.analyze.AnalyzerLogger;
import org.mule.tools.maven.plugin.module.analyze.ClassFileVisitor;
import org.mule.tools.maven.plugin.module.analyze.DefaultModuleApiAnalyzer;
import org.mule.tools.maven.plugin.module.analyze.asm.DefaultAnnotationVisitor;
import org.mule.tools.maven.plugin.module.analyze.asm.DefaultClassVisitor;
import org.mule.tools.maven.plugin.module.analyze.asm.DefaultFieldVisitor;
import org.mule.tools.maven.plugin.module.analyze.asm.DefaultMethodVisitor;
import org.mule.tools.maven.plugin.module.analyze.asm.DefaultSignatureVisitor;
import org.mule.tools.maven.plugin.module.analyze.asm.ResultCollector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class DependencyClassFileVisitor
implements ClassFileVisitor {
    private final ResultCollector resultCollector;
    private final AnalyzerLogger analyzerLogger;

    public DependencyClassFileVisitor(AnalyzerLogger analyzerLogger) {
        this.analyzerLogger = analyzerLogger;
        this.resultCollector = new ResultCollector(analyzerLogger);
    }

    @Override
    public void visitClass(String className, InputStream in) {
        if (className.startsWith("META-INF.") || className.equals("module-info")) {
            return;
        }
        try {
            String packageName = DefaultModuleApiAnalyzer.getPackageName(className);
            ClassReader reader = new ClassReader(in);
            DefaultAnnotationVisitor annotationVisitor = new DefaultAnnotationVisitor(packageName, this.resultCollector, this.analyzerLogger);
            DefaultSignatureVisitor signatureVisitor = new DefaultSignatureVisitor(packageName, this.resultCollector, this.analyzerLogger);
            DefaultFieldVisitor fieldVisitor = new DefaultFieldVisitor(packageName, annotationVisitor, this.resultCollector, this.analyzerLogger);
            DefaultMethodVisitor mv = new DefaultMethodVisitor(packageName, annotationVisitor, signatureVisitor, this.resultCollector, this.analyzerLogger);
            DefaultClassVisitor classVisitor = new DefaultClassVisitor(packageName, signatureVisitor, annotationVisitor, fieldVisitor, mv, this.resultCollector, this.analyzerLogger);
            reader.accept((ClassVisitor)classVisitor, 0);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            this.analyzerLogger.log("Unable to process: " + className);
        }
    }

    public Set<String> getDependencies() {
        return this.resultCollector.getDependencies();
    }

    public Map<String, Set<String>> getPackageDeps() {
        return this.resultCollector.getPackageDeps();
    }
}

