/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.module.analyze;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.codehaus.plexus.util.DirectoryScanner;
import org.mule.tools.maven.plugin.module.analyze.AnalyzerLogger;
import org.mule.tools.maven.plugin.module.analyze.ClassFileVisitor;

public final class ClassFileVisitorUtils {
    private static final String[] CLASS_INCLUDES = new String[]{"**/*.class"};

    private ClassFileVisitorUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void accept(URL url, ClassFileVisitor visitor, AnalyzerLogger analyzerLogger) throws IOException {
        analyzerLogger.log("Analyzing: " + url);
        if (url.getPath().endsWith(".jar")) {
            ClassFileVisitorUtils.acceptJar(url, visitor);
            return;
        }
        if (!url.getProtocol().equalsIgnoreCase("file")) throw new IllegalArgumentException("Cannot accept visitor on URL: " + url);
        try {
            File file = new File(new URI(url.toString()));
            if (file.isDirectory()) {
                ClassFileVisitorUtils.acceptDirectory(file, visitor);
                return;
            } else {
                if (!file.exists()) return;
                throw new IllegalArgumentException("Cannot accept visitor on URL: " + url);
            }
        }
        catch (URISyntaxException exception) {
            IllegalArgumentException e = new IllegalArgumentException("Cannot accept visitor on URL: " + url, exception);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void acceptJar(URL url, ClassFileVisitor visitor) throws IOException {
        try (JarInputStream in = new JarInputStream(url.openStream());){
            JarEntry entry = null;
            while ((entry = in.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                ClassFileVisitorUtils.visitClass(name, in, visitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void acceptDirectory(File directory, ClassFileVisitor visitor) throws IOException {
        String[] paths;
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("File is not a directory");
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(CLASS_INCLUDES);
        scanner.scan();
        for (String path : paths = scanner.getIncludedFiles()) {
            path = path.replace(File.separatorChar, '/');
            File file = new File(directory, path);
            try (FileInputStream in = new FileInputStream(file);){
                ClassFileVisitorUtils.visitClass(path, in, visitor);
            }
        }
    }

    private static void visitClass(String path, InputStream in, ClassFileVisitor visitor) {
        if (!path.endsWith(".class")) {
            throw new IllegalArgumentException("Path is not a class");
        }
        String className = path.substring(0, path.length() - 6);
        className = className.replace('/', '.');
        visitor.visitClass(className, in);
    }
}

