/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.module.analyze;

import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.codehaus.plexus.util.PropertyUtils;

public class JrePackageFinder {
    private static final String JRE_PACKAGES_PROPERTIES = "jre-packages.properties";
    private static final String UNABLE_TO_DETERMINE_JRE_PACKAGES_ERROR = "Unable to determine packages exported by the JRE";

    private JrePackageFinder() {
    }

    public static Set<String> find() {
        try {
            Properties properties = PropertyUtils.loadProperties((URL)JrePackageFinder.class.getClassLoader().getResource(JRE_PACKAGES_PROPERTIES));
            String jreVersionProperty = "jre-1.8";
            if (!properties.keySet().contains("jre-1.8")) {
                throw new IllegalStateException(UNABLE_TO_DETERMINE_JRE_PACKAGES_ERROR);
            }
            String packages = (String)properties.get("jre-1.8");
            HashSet<String> result = new HashSet<String>();
            for (String jrePackage : packages.split(",")) {
                if ((jrePackage = jrePackage.trim()).isEmpty()) continue;
                result.add(jrePackage);
            }
            return result;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to determine JRE provided packages", e);
        }
    }
}

