/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.module.analyze;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.mule.tools.maven.plugin.module.analyze.AnalyzerLogger;
import org.mule.tools.maven.plugin.module.analyze.Module;

public class ModuleFactory {
    public Module create(AnalyzerLogger analyzerLogger, String moduleName, Properties properties) throws IOException {
        Set<String> modulePackages = this.getModuleExportedPackages(analyzerLogger, properties);
        Set<String> moduleOptionalPackages = this.getModuleOptionalPackages(analyzerLogger, properties);
        Set<String> modulePrivilegedPackages = this.getModulePrivilegedExportedPackages(analyzerLogger, properties);
        return new Module(moduleName, modulePackages, modulePrivilegedPackages, moduleOptionalPackages);
    }

    private Set<String> getModuleExportedPackages(AnalyzerLogger analyzerLogger, Properties properties) throws IOException {
        return this.getModulePackagesFromProperty(analyzerLogger, properties, "artifact.export.classPackages");
    }

    private Set<String> getModulePrivilegedExportedPackages(AnalyzerLogger analyzerLogger, Properties properties) throws IOException {
        return this.getModulePackagesFromProperty(analyzerLogger, properties, "artifact.privileged.classPackages");
    }

    private Set<String> getModuleOptionalPackages(AnalyzerLogger analyzerLogger, Properties properties) throws IOException {
        return this.getModulePackagesFromProperty(analyzerLogger, properties, "artifact.export.optionalPackages");
    }

    private Set<String> getModulePackagesFromProperty(AnalyzerLogger analyzerLogger, Properties properties, String key) {
        HashSet<String> optionalPackages = new HashSet<String>();
        String classPackages = (String)properties.get(key);
        if (classPackages != null) {
            StringBuilder builder = new StringBuilder("Found module: " + properties.get("module.name") + " with property=" + key + ":");
            for (String classPackage : classPackages.split(",")) {
                if (classPackage == null || (classPackage = classPackage.trim()) == null) continue;
                optionalPackages.add(classPackage);
                builder.append("\n").append(classPackage);
            }
            analyzerLogger.log(builder.toString());
        }
        return optionalPackages;
    }
}

