/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.module.generate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.tools.maven.plugin.module.analyze.ModuleApiAnalyzerException;
import org.mule.tools.maven.plugin.module.analyze.ProjectAnalysisResult;
import org.mule.tools.maven.plugin.module.analyze.SilentAnalyzerLogger;
import org.mule.tools.maven.plugin.module.bean.ServiceDefinition;
import org.mule.tools.maven.plugin.module.common.AbstractModuleMojo;
import org.mule.tools.maven.plugin.module.generate.PrivilegedApiReflectiveWrapper;

@Mojo(name="generate", requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class GenerateMojo
extends AbstractModuleMojo {
    @Parameter(property="muleModule.generate.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="false")
    private boolean fillOptionalPackages;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.project.getPackaging().equals("jar")) {
            this.getLog().info((CharSequence)("Project is of type '" + this.project.getPackaging() + "', not 'jar'. Skipping..."));
            return;
        }
        try {
            this.doExecute();
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public void doExecute() throws MojoFailureException, Exception {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        this.getLog().info((CharSequence)"Resolving current module...");
        Optional<Module> currentModuleOpt = this.resolveCurrentModule();
        if (currentModuleOpt.isEmpty()) {
            this.getLog().info((CharSequence)"No module found. Skipping...");
            return;
        }
        Module currentModule = currentModuleOpt.get();
        this.getLog().info((CharSequence)("Loading module information for '" + currentModule.getName() + "'..."));
        org.mule.tools.maven.plugin.module.bean.Module muleModule = this.toMuleModule(currentModule);
        this.getLog().info((CharSequence)("Setting properties for mule module '" + currentModule.getName() + "'..."));
        Properties properties = this.toMuleModuleProperties(muleModule);
        this.getLog().info((CharSequence)("Saving generated files for module '" + currentModule.getName() + "'..."));
        this.writeFiles(muleModule, properties);
    }

    private org.mule.tools.maven.plugin.module.bean.Module toMuleModule(Module currentModule) throws ClassNotFoundException, ModuleApiAnalyzerException, MojoExecutionException {
        ProjectAnalysisResult analysis;
        Set<String> additionalOptionalPackages;
        PrivilegedApiReflectiveWrapper privilegedApiReflectiveWrapper = new PrivilegedApiReflectiveWrapper(currentModule);
        Set optionalPackages = Stream.of(privilegedApiReflectiveWrapper.getOptionalPackages()).collect(Collectors.toCollection(TreeSet::new));
        Set exportedPrivilegedPackages = Stream.of(privilegedApiReflectiveWrapper.getPrivilegedPackages()).collect(Collectors.toCollection(TreeSet::new));
        Set modulePrivilegedArtifactIds = Stream.of(privilegedApiReflectiveWrapper.getPrivilegedArtifactIds()).collect(Collectors.toCollection(TreeSet::new));
        Set<String> exportedPackages = this.resolveExportedPackages(currentModule, exportedPrivilegedPackages);
        TreeSet moduleServiceDefinitions = currentModule.getDescriptor().provides().stream().map(provides -> {
            ServiceDefinition serviceDefinition = new ServiceDefinition();
            serviceDefinition.setServiceInterface(provides.service());
            serviceDefinition.setServiceImplementations(provides.providers().stream().collect(Collectors.toList()));
            return serviceDefinition;
        }).collect(Collectors.toCollection(TreeSet::new));
        org.mule.tools.maven.plugin.module.bean.Module generatedModule = new org.mule.tools.maven.plugin.module.bean.Module(currentModule.getName(), exportedPackages, exportedPrivilegedPackages, optionalPackages, modulePrivilegedArtifactIds, moduleServiceDefinitions);
        if (this.fillOptionalPackages && !(additionalOptionalPackages = (analysis = this.analyzer.analyze(this.project, generatedModule, new SilentAnalyzerLogger(), this.getLog())).getStandardApi().getPackagesToExport()).isEmpty()) {
            optionalPackages.addAll(additionalOptionalPackages);
            generatedModule = new org.mule.tools.maven.plugin.module.bean.Module(currentModule.getName(), exportedPackages, exportedPrivilegedPackages, optionalPackages, modulePrivilegedArtifactIds, moduleServiceDefinitions);
        }
        return generatedModule;
    }

    private boolean isProvidedServiceExported(Set<String> exportedPrivilegedPackages, Set<String> exportedPackages, String providedService) {
        String packageName = providedService.substring(0, providedService.lastIndexOf("."));
        return exportedPackages.contains(packageName) || exportedPrivilegedPackages.contains(packageName);
    }

    private Set<String> resolveExportedPackages(Module currentModule, Set<String> exportedPrivilegedPackages) {
        Set exportedPackages = currentModule.getPackages().stream().filter(Predicate.not(exportedPrivilegedPackages::contains)).filter(pkg -> currentModule.isExported((String)pkg)).collect(Collectors.toCollection(TreeSet::new));
        exportedPackages.addAll(currentModule.getDescriptor().requires().stream().filter(req -> req.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.TRANSITIVE)).filter(req -> ModuleLayer.boot().findModule(req.name()).isEmpty()).filter(Predicate.not(req -> this.isMuleModuleRequired(currentModule, (ModuleDescriptor.Requires)req))).map(req -> currentModule.getLayer().findModule(req.name()).get()).flatMap(transitiveNonMuleModule -> this.resolveExportedPackages((Module)transitiveNonMuleModule, exportedPrivilegedPackages).stream()).collect(Collectors.toList()));
        return exportedPackages;
    }

    private Boolean isMuleModuleRequired(Module currentModule, ModuleDescriptor.Requires req) {
        return currentModule.getLayer().findModule(req.name()).map(reqMod -> {
            try {
                return reqMod.getResourceAsStream("META-INF/mule-module.properties") != null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).orElse(false);
    }

    private Optional<Module> resolveCurrentModule() throws MojoFailureException {
        try {
            ModuleFinder currentModuleFinder = ModuleFinder.of(Path.of(this.project.getBuild().getOutputDirectory(), new String[0]));
            List<String> roots = currentModuleFinder.findAll().stream().map(moduleRef -> moduleRef.descriptor().name()).collect(Collectors.toList());
            Optional<Path> xmlApisPath = Optional.ofNullable((Artifact)this.project.getArtifactMap().get("xml-apis:xml-apis")).map(xmlApisArtifact -> xmlApisArtifact.getFile().toPath());
            Collection directTestDependencies = this.project.getDependencies().stream().filter(dependency -> "test".equals(dependency.getScope())).map(dependency -> (Artifact)this.project.getArtifactMap().get(dependency.getGroupId() + ":" + dependency.getArtifactId())).map(artifact -> artifact.getFile().getAbsolutePath()).collect(Collectors.toSet());
            ModuleFinder finder = ModuleFinder.of((Path[])Stream.concat(this.project.getCompileClasspathElements().stream(), directTestDependencies.stream()).map(cpe -> Paths.get(cpe, new String[0])).filter(path -> xmlApisPath.map(path::equals).orElse(false) == false).toArray(Path[]::new));
            Configuration configuration = ModuleLayer.boot().configuration().resolve(finder, ModuleFinder.ofSystem(), roots);
            ModuleLayer.Controller controller = ModuleLayer.defineModulesWithOneLoader(configuration, Collections.singletonList(ModuleLayer.boot()), ClassLoader.getSystemClassLoader());
            return finder.findAll().stream().filter(modRef -> roots.contains(modRef.descriptor().name())).map(modRef -> modRef.descriptor().name()).findFirst().flatMap(controller.layer()::findModule);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private Properties toMuleModuleProperties(org.mule.tools.maven.plugin.module.bean.Module muleModule) {
        Properties properties = new Properties();
        properties.put("module.name", muleModule.getName());
        if (!muleModule.getExportedPackages().isEmpty()) {
            properties.put("artifact.export.classPackages", muleModule.getExportedPackages().stream().collect(Collectors.joining(",")));
        }
        if (!muleModule.getExportedPrivilegedPackages().isEmpty()) {
            properties.put("artifact.privileged.classPackages", muleModule.getExportedPrivilegedPackages().stream().collect(Collectors.joining(",")));
        }
        if (!muleModule.getModulePrivilegedArtifactIds().isEmpty()) {
            properties.put("artifact.privileged.artifactIds", muleModule.getModulePrivilegedArtifactIds().stream().collect(Collectors.joining(",")));
        }
        if (!muleModule.getOptionalExportedPackages().isEmpty()) {
            properties.put("artifact.export.optionalPackages", muleModule.getOptionalExportedPackages().stream().collect(Collectors.joining(",")));
        }
        if (!muleModule.getModuleServiceDefinitions().isEmpty()) {
            StringBuilder propertyValue = new StringBuilder();
            for (ServiceDefinition serviceDefinition : muleModule.getModuleServiceDefinitions()) {
                for (String serviceImplementation : serviceDefinition.getServiceImplementations()) {
                    if (!this.isProvidedServiceExported(muleModule.getExportedPackages(), muleModule.getExportedPrivilegedPackages(), serviceImplementation)) continue;
                    propertyValue.append(serviceDefinition.getServiceInterface()).append(":").append(serviceImplementation).append(",");
                }
            }
            if (propertyValue.length() > 0) {
                properties.put("artifact.export.services", propertyValue.substring(0, propertyValue.length() - 1));
            }
        }
        return properties;
    }

    private void writeFiles(org.mule.tools.maven.plugin.module.bean.Module muleModule, Properties properties) throws MojoFailureException, IOException, FileNotFoundException {
        File outputModuleFile;
        if (!muleModule.getModuleServiceDefinitions().isEmpty()) {
            for (ServiceDefinition serviceDefinition : muleModule.getModuleServiceDefinitions()) {
                File outputServiceFile = new File(this.project.getBuild().getOutputDirectory(), "META-INF/services/" + serviceDefinition.getServiceInterface());
                if (!(outputServiceFile.getParentFile().isDirectory() && outputServiceFile.getParentFile().exists() || outputServiceFile.getParentFile().mkdirs())) {
                    throw new MojoFailureException("Could not create directory '" + outputServiceFile.getParentFile().getAbsolutePath() + "'.");
                }
                if (!outputServiceFile.exists()) {
                    this.getLog().info((CharSequence)("Writing '" + outputServiceFile.getAbsolutePath() + "'..."));
                    OutputStreamWriter fw = new OutputStreamWriter(new FileOutputStream(outputServiceFile));
                    try {
                        IOUtils.write((String)("#Generated by org.mule.tools.maven.plugin.module.generate.GenerateMojo" + IOUtils.LINE_SEPARATOR_UNIX), (Writer)fw);
                        IOUtils.writeLines(serviceDefinition.getServiceImplementations(), (String)IOUtils.LINE_SEPARATOR_UNIX, (Writer)fw);
                        fw.flush();
                        continue;
                    }
                    finally {
                        fw.close();
                        continue;
                    }
                }
                this.getLog().info((CharSequence)("Service descriptor for '" + serviceDefinition.getServiceInterface() + "' already present, skipping."));
            }
        }
        if ((outputModuleFile = new File(this.project.getBuild().getOutputDirectory(), "META-INF/mule-module.properties")).exists() && this.isExistingModulePropertiesFileEqual(properties, outputModuleFile)) {
            this.getLog().info((CharSequence)("No changes detected for '" + outputModuleFile.getAbsolutePath() + "' skipping."));
            return;
        }
        if (!(outputModuleFile.getParentFile().isDirectory() && outputModuleFile.getParentFile().exists() || outputModuleFile.getParentFile().mkdirs())) {
            throw new MojoFailureException("Could not create directory '" + outputModuleFile.getParentFile().getAbsolutePath() + "'.");
        }
        this.getLog().info((CharSequence)("Writing '" + outputModuleFile.getAbsolutePath() + "'..."));
        try (FileOutputStream fos = new FileOutputStream(outputModuleFile);){
            properties.store(fos, "Generated by org.mule.tools.maven.plugin.module.generate.GenerateMojo");
            fos.flush();
        }
    }

    private boolean isExistingModulePropertiesFileEqual(Properties newProperties, File moduleFile) {
        boolean bl;
        Properties existingProperties = new Properties();
        FileInputStream fis = new FileInputStream(moduleFile);
        try {
            existingProperties.load(fis);
            bl = existingProperties.equals(newProperties);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.getLog().info((CharSequence)("Unable to read existing module properties file'" + moduleFile.getAbsolutePath() + "'..."));
                return false;
            }
        }
        fis.close();
        return bl;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

