/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.module.analyze;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.mule.tools.maven.plugin.module.analyze.ApiAnalysisResult;
import org.mule.tools.maven.plugin.module.analyze.DependencyAnalyzer;
import org.mule.tools.maven.plugin.module.analyze.JrePackageFinder;
import org.mule.tools.maven.plugin.module.analyze.ModuleApiAnalyzer;
import org.mule.tools.maven.plugin.module.analyze.ModuleApiAnalyzerException;
import org.mule.tools.maven.plugin.module.analyze.ModuleDiscoverer;
import org.mule.tools.maven.plugin.module.analyze.ProjectAnalysisResult;
import org.mule.tools.maven.plugin.module.bean.Module;
import org.mule.tools.maven.plugin.module.common.ModuleLogger;

@Component(role=ModuleApiAnalyzer.class)
public class DefaultModuleApiAnalyzer
implements ModuleApiAnalyzer {
    public static final String PROJECT_IS_NOT_A_MULE_MODULE = "Project is not a mule module";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final String EMPTY_PACKAGE = "";
    @Requirement
    private DependencyAnalyzer dependencyAnalyzer;
    private final ModuleDiscoverer moduleDiscoverer = new ModuleDiscoverer();

    public static String getPackageName(String className) {
        return className.lastIndexOf(46) < 0 ? EMPTY_PACKAGE : className.substring(0, className.lastIndexOf(46));
    }

    @Override
    public ProjectAnalysisResult analyze(MavenProject project, ModuleLogger analyzerLogger, Log log) throws ModuleApiAnalyzerException {
        Module module = this.moduleDiscoverer.discoverProjectModule(project, analyzerLogger);
        if (module == null) {
            log.info((CharSequence)PROJECT_IS_NOT_A_MULE_MODULE);
            return new ProjectAnalysisResult(null, null);
        }
        return this.analyze(project, module, analyzerLogger, log);
    }

    @Override
    public ProjectAnalysisResult analyze(MavenProject project, Module module, ModuleLogger analyzerLogger, Log log) throws ModuleApiAnalyzerException {
        try {
            List<Module> modules = this.moduleDiscoverer.discoverExternalModules(project, analyzerLogger, module.getName());
            this.checkExportedOptionalPackage(analyzerLogger, module.getExportedPackages(), module.getOptionalExportedPackages());
            Set<String> externalExportedPackages = this.getExternalExportedPackages(modules);
            Map<String, Set<String>> projectPackageDependencies = this.findPackageDependencies(project, analyzerLogger);
            Map<String, Set<String>> externalPackageDeps = this.calculateExternalDeps(project, analyzerLogger);
            ApiAnalysisResult standardApiAnalysisResult = this.analyzeApi(analyzerLogger, module.getExportedPackages(), module.getOptionalExportedPackages(), externalExportedPackages, projectPackageDependencies, externalPackageDeps);
            this.logPackageClosure(analyzerLogger, standardApiAnalysisResult.getExportedPackageClosure());
            ApiAnalysisResult privilegedApiAnalysisResult = null;
            if (!module.getExportedPrivilegedPackages().isEmpty()) {
                Set<String> externalPrivilegedExportedPackages = this.getExternalExportedPrivilegedPackages(modules);
                HashSet<String> exportedPackages = new HashSet<String>(module.getExportedPackages());
                exportedPackages.addAll(externalExportedPackages);
                exportedPackages.addAll(externalPrivilegedExportedPackages);
                privilegedApiAnalysisResult = this.analyzeApi(analyzerLogger, module.getExportedPrivilegedPackages(), module.getOptionalExportedPackages(), exportedPackages, projectPackageDependencies, externalPackageDeps);
            }
            this.logPrivilegedPackageClosure(analyzerLogger, standardApiAnalysisResult.getExportedPackageClosure());
            return new ProjectAnalysisResult(standardApiAnalysisResult, privilegedApiAnalysisResult);
        }
        catch (Exception exception) {
            throw new ModuleApiAnalyzerException("Cannot analyze dependencies", exception);
        }
    }

    private ApiAnalysisResult analyzeApi(ModuleLogger analyzerLogger, Set<String> projectExportedPackages, Set<String> projectOptionalPackages, Set<String> externalExportedPackages, Map<String, Set<String>> projectPackageDependencies, Map<String, Set<String>> externalPackageDeps) {
        HashSet<String> diff;
        boolean dirty;
        Set<String> duplicatedPackages = this.removeExternalModuleExportedPackage(projectExportedPackages, externalExportedPackages);
        projectExportedPackages.removeAll(duplicatedPackages);
        HashSet<String> exportedPackageClosure = new HashSet<String>(projectExportedPackages);
        HashSet<String> missingAnalyzedPackages = new HashSet<String>();
        Set<String> jrePackages = JrePackageFinder.find();
        HashMap<String, Set<String>> missingExportedPackages = new HashMap<String, Set<String>>();
        do {
            diff = new HashSet<String>();
            HashSet exportedByOtherModule = new HashSet();
            for (String exportedPackage : exportedPackageClosure) {
                if (this.ignorePackage(analyzerLogger, exportedPackage, jrePackages, externalExportedPackages)) continue;
                Set<String> packageDeps = projectPackageDependencies.get(exportedPackage);
                if (packageDeps != null) {
                    for (String packageDep : packageDeps) {
                        if (exportedPackageClosure.contains(packageDep) || this.ignorePackage(analyzerLogger, packageDep, jrePackages, externalExportedPackages)) continue;
                        diff.add(packageDep);
                    }
                    continue;
                }
                packageDeps = externalPackageDeps.get(exportedPackage);
                if (packageDeps != null) {
                    for (String packageDep : packageDeps) {
                        if (exportedPackageClosure.contains(packageDep) || this.ignorePackage(analyzerLogger, packageDep, jrePackages, externalExportedPackages)) continue;
                        diff.add(packageDep);
                    }
                    continue;
                }
                if (externalExportedPackages.contains(exportedPackage) || projectOptionalPackages.contains(exportedPackage)) continue;
                missingAnalyzedPackages.add(exportedPackage);
            }
            exportedPackageClosure.addAll(diff);
            exportedPackageClosure.removeAll(exportedByOtherModule);
            diff.removeAll(exportedByOtherModule);
        } while (dirty = !diff.isEmpty());
        Set<String> packagesToExport = this.sanitizePackagesToExport(projectExportedPackages, projectOptionalPackages, exportedPackageClosure);
        return new ApiAnalysisResult(missingExportedPackages, packagesToExport, missingAnalyzedPackages, duplicatedPackages, exportedPackageClosure);
    }

    private Set<String> sanitizePackagesToExport(Set<String> projectExportedPackages, Set<String> projectOptionalPackages, Set<String> exportedPackageClosure) {
        HashSet<String> packagesToExport = new HashSet<String>(exportedPackageClosure);
        packagesToExport.removeAll(projectExportedPackages);
        packagesToExport.removeAll(projectOptionalPackages);
        return packagesToExport;
    }

    private void logPackageClosure(ModuleLogger analyzerLogger, Set<String> exportedPackageClosure) {
        this.logPackageClosure(analyzerLogger, exportedPackageClosure, "Exported package closure:");
    }

    private void logPrivilegedPackageClosure(ModuleLogger analyzerLogger, Set<String> exportedPackageClosure) {
        this.logPackageClosure(analyzerLogger, exportedPackageClosure, "Exported privileged package closure:");
    }

    private void logPackageClosure(ModuleLogger analyzerLogger, Set<String> exportedPackageClosure, String message) {
        StringBuilder builder = new StringBuilder(message);
        for (String exportedPackage : exportedPackageClosure) {
            builder.append("\n").append(exportedPackage);
        }
        analyzerLogger.log(builder.toString());
    }

    private void checkExportedOptionalPackage(ModuleLogger analyzerLogger, Set<String> projectExportedPackages, Set<String> projectOptionalPackages) throws ModuleApiAnalyzerException {
        ArrayList<String> packages = new ArrayList<String>();
        for (String projectOptionalPackage : projectOptionalPackages) {
            if (!projectExportedPackages.contains(projectOptionalPackage)) continue;
            packages.add(projectOptionalPackage);
        }
        if (!packages.isEmpty()) {
            String message = DefaultModuleApiAnalyzer.buildOptionalPackageExportedMessage(packages);
            analyzerLogger.log(message);
            throw new ModuleApiAnalyzerException(message);
        }
    }

    private Set<String> removeExternalModuleExportedPackage(Set<String> projectExportedPackages, Set<String> externalExportedPackages) {
        HashSet<String> duplicatedPackages = new HashSet<String>();
        for (String externalExportedPackage : externalExportedPackages) {
            if (!projectExportedPackages.contains(externalExportedPackage)) continue;
            duplicatedPackages.add(externalExportedPackage);
        }
        return duplicatedPackages;
    }

    public static String buildOptionalPackageExportedMessage(List<String> packages) {
        return "Module exports packages defined as optional: " + packages;
    }

    public static String buildRemovedProvidedPackageMessage(String packageName) {
        return "Package " + packageName + " already exported by a module dependency. Removing from export package closure";
    }

    public static String buildRemovedSunPackageMessage(String packageName) {
        return "Removing internal SUN package " + packageName + " from export package closure";
    }

    public static String buildRemovedJrePackageMessage(String packageName) {
        return "Removing JRE package " + packageName + " from export package closure";
    }

    private boolean ignorePackage(ModuleLogger analyzerLogger, String packageName, Set<String> jrePackages, Set<String> otherModuleExportedPackages) {
        boolean result = false;
        if (otherModuleExportedPackages.contains(packageName)) {
            analyzerLogger.log(DefaultModuleApiAnalyzer.buildRemovedProvidedPackageMessage(packageName));
            result = true;
        } else if (jrePackages.contains(packageName)) {
            analyzerLogger.log(DefaultModuleApiAnalyzer.buildRemovedJrePackageMessage(packageName));
            result = true;
        } else if (packageName.startsWith("sun.") || packageName.startsWith("com.sun.")) {
            analyzerLogger.log(DefaultModuleApiAnalyzer.buildRemovedSunPackageMessage(packageName));
            result = true;
        }
        return result;
    }

    private Set<String> getExternalExportedPackages(List<Module> modules) throws ModuleApiAnalyzerException {
        HashSet<String> result = new HashSet<String>();
        for (Module module : modules) {
            result.addAll(module.getExportedPackages());
        }
        return result;
    }

    private Set<String> getExternalExportedPrivilegedPackages(List<Module> modules) throws ModuleApiAnalyzerException {
        HashSet<String> result = new HashSet<String>();
        for (Module module : modules) {
            result.addAll(module.getExportedPrivilegedPackages());
        }
        return result;
    }

    private Map<String, Set<String>> calculateExternalDeps(MavenProject project, ModuleLogger analyzerLogger) throws IOException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Object projectArtifact : project.getArtifacts()) {
            Artifact artifact = (Artifact)projectArtifact;
            if ("test".equals(artifact.getScope())) {
                analyzerLogger.log("Skipping test artifact: " + artifact.getFile().toString());
                continue;
            }
            Map<String, Set<String>> artifactExternalPackageDeps = this.findPackageDependencies(artifact.getFile().toString(), analyzerLogger);
            for (String externalPackageName : artifactExternalPackageDeps.keySet()) {
                Set<String> packageDeps = artifactExternalPackageDeps.get(externalPackageName);
                HashSet<String> externalPackageDeps = (HashSet<String>)result.get(externalPackageName);
                if (externalPackageDeps == null) {
                    externalPackageDeps = new HashSet<String>();
                    result.put(externalPackageName, externalPackageDeps);
                }
                externalPackageDeps.addAll(packageDeps);
            }
        }
        return result;
    }

    protected Map<String, Set<String>> findPackageDependencies(MavenProject project, ModuleLogger analyzerLogger) throws IOException {
        String outputDirectory = project.getBuild().getOutputDirectory();
        Map<String, Set<String>> packageDeps = this.findPackageDependencies(outputDirectory, analyzerLogger);
        return packageDeps;
    }

    private Map<String, Set<String>> findPackageDependencies(String path, ModuleLogger analyzerLogger) throws IOException {
        URL url = new File(path).toURI().toURL();
        return this.dependencyAnalyzer.analyze(url, analyzerLogger);
    }
}

