/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.module.bean;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.mule.tools.maven.plugin.module.bean.Module;
import org.mule.tools.maven.plugin.module.bean.ServiceDefinition;
import org.mule.tools.maven.plugin.module.common.ModuleLogger;

public class ModuleFactory {
    public Module create(ModuleLogger analyzerLogger, String moduleName, Properties properties) throws IOException {
        Set<String> modulePackages = this.getModuleExportedPackages(analyzerLogger, properties);
        Set<String> moduleOptionalPackages = this.getModuleOptionalPackages(analyzerLogger, properties);
        Set<String> modulePrivilegedPackages = this.getModulePrivilegedExportedPackages(analyzerLogger, properties);
        Set<String> modulePrivilegedArtifactIds = this.getModulePrivilegedArtifactIds(analyzerLogger, properties);
        Set<ServiceDefinition> moduleServiceDefinitions = this.getModuleServiceDefinitions(analyzerLogger, properties);
        return new Module(moduleName, modulePackages, modulePrivilegedPackages, moduleOptionalPackages, modulePrivilegedArtifactIds, moduleServiceDefinitions);
    }

    private Set<String> getModuleExportedPackages(ModuleLogger analyzerLogger, Properties properties) throws IOException {
        return this.getValuesFromProperty(analyzerLogger, properties, "artifact.export.classPackages");
    }

    private Set<String> getModulePrivilegedExportedPackages(ModuleLogger analyzerLogger, Properties properties) throws IOException {
        return this.getValuesFromProperty(analyzerLogger, properties, "artifact.privileged.classPackages");
    }

    private Set<String> getModuleOptionalPackages(ModuleLogger analyzerLogger, Properties properties) throws IOException {
        return this.getValuesFromProperty(analyzerLogger, properties, "artifact.export.optionalPackages");
    }

    private Set<String> getModulePrivilegedArtifactIds(ModuleLogger analyzerLogger, Properties properties) throws IOException {
        return this.getValuesFromProperty(analyzerLogger, properties, "artifact.privileged.artifactIds");
    }

    private Set<ServiceDefinition> getModuleServiceDefinitions(ModuleLogger analyzerLogger, Properties properties) {
        Set<String> rawServiceDefinitions = this.getValuesFromProperty(analyzerLogger, properties, "artifact.export.services");
        TreeMap<String, List> services = new TreeMap<String, List>();
        for (String valueFromProperty : rawServiceDefinitions) {
            String[] split = valueFromProperty.split(":");
            if (split.length != 2) {
                throw new IllegalStateException("Invalid service definition '" + valueFromProperty + "'. Must be of format '<interface fqcn>:<implementation fqcn>'");
            }
            services.computeIfAbsent(split[0], k -> new ArrayList()).add(split[1]);
        }
        return services.entrySet().stream().map(entry -> {
            ServiceDefinition serviceDefinition = new ServiceDefinition();
            serviceDefinition.setServiceInterface((String)entry.getKey());
            serviceDefinition.setServiceImplementations((List)entry.getValue());
            return serviceDefinition;
        }).collect(Collectors.toCollection(TreeSet::new));
    }

    private Set<String> getValuesFromProperty(ModuleLogger analyzerLogger, Properties properties, String key) {
        TreeSet<String> values = new TreeSet<String>();
        String rawValues = (String)properties.get(key);
        if (rawValues != null) {
            StringBuilder builder = new StringBuilder("Found module: " + properties.get("module.name") + " with property=" + key + ":");
            for (String value : rawValues.split(",")) {
                if (value == null || (value = value.trim()) == null || "".equals(value)) continue;
                values.add(value);
                builder.append("\n").append(value);
            }
            analyzerLogger.log(builder.toString());
        }
        return values;
    }
}

