/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.module.analyze.asm;

import org.mule.tools.maven.plugin.module.analyze.asm.AccessUtils;
import org.mule.tools.maven.plugin.module.analyze.asm.ResultCollector;
import org.mule.tools.maven.plugin.module.common.ModuleLogger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class DefaultClassVisitor
extends ClassVisitor {
    private final ResultCollector resultCollector;
    private final ModuleLogger analyzerLogger;
    private final String packageName;
    private final SignatureVisitor signatureVisitor;
    private final AnnotationVisitor annotationVisitor;
    private final FieldVisitor fieldVisitor;
    private final MethodVisitor methodVisitor;
    private boolean skipClass;
    private boolean isFinalClass;

    public DefaultClassVisitor(String packageName, SignatureVisitor signatureVisitor, AnnotationVisitor annotationVisitor, FieldVisitor fieldVisitor, MethodVisitor methodVisitor, ResultCollector resultCollector, ModuleLogger analyzerLogger) {
        super(327680);
        this.packageName = packageName;
        this.signatureVisitor = signatureVisitor;
        this.annotationVisitor = annotationVisitor;
        this.fieldVisitor = fieldVisitor;
        this.methodVisitor = methodVisitor;
        this.resultCollector = resultCollector;
        this.analyzerLogger = analyzerLogger;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.analyzerLogger.log("Analyzing class: " + name + (signature != null ? signature : ""));
        this.resultCollector.addName(this.packageName, name);
        boolean bl = this.skipClass = AccessUtils.isPrivate(access) || AccessUtils.isPackage(access);
        if (this.skipClass) {
            String accessString = AccessUtils.isPrivate(access) ? "private" : "package";
            this.analyzerLogger.log("Skipping class: " + name + (signature != null ? signature : "") + " visibility: " + accessString);
        } else {
            this.isFinalClass = AccessUtils.isFinal(access);
            if (signature == null) {
                this.resultCollector.addName(this.packageName, superName);
                this.resultCollector.addNames(this.packageName, interfaces);
            } else {
                this.addSignature(signature);
            }
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.skipClass) {
            return null;
        }
        if (visible) {
            this.resultCollector.addDesc(this.packageName, desc);
            return this.annotationVisitor;
        }
        return null;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.skipClass) {
            return null;
        }
        if (AccessUtils.isPublic(access) || AccessUtils.isProtected(access) && !this.isFinalClass) {
            String accessString = AccessUtils.isPublic(access) ? "public" : "protected";
            this.analyzerLogger.log("Analyzing field: " + name + " - " + accessString);
            if (signature == null) {
                this.resultCollector.addDesc(this.packageName, desc);
            } else {
                this.addTypeSignature(signature);
            }
            if (value instanceof Type) {
                this.resultCollector.addType(this.packageName, (Type)value);
            }
            return this.fieldVisitor;
        }
        String accessString = AccessUtils.isPrivate(access) ? "private" : "package";
        this.analyzerLogger.log("Analyzing field: " + name + " - " + accessString);
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.skipClass) {
            return null;
        }
        if (AccessUtils.isPrivate(access) || AccessUtils.isPackage(access) || AccessUtils.isProtected(access) && this.isFinalClass) {
            return null;
        }
        if (signature == null) {
            this.resultCollector.addMethodDesc(this.packageName, desc);
        } else {
            this.addSignature(signature);
        }
        this.resultCollector.addNames(this.packageName, exceptions);
        return this.methodVisitor;
    }

    private void addSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).accept(this.signatureVisitor);
        }
    }

    private void addTypeSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).acceptType(this.signatureVisitor);
        }
    }
}

