/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.module.analyze.asm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.tools.maven.plugin.module.analyze.DefaultModuleApiAnalyzer;
import org.mule.tools.maven.plugin.module.common.ModuleLogger;
import org.objectweb.asm.Type;

public class ResultCollector {
    private final Set<String> classes = new HashSet<String>();
    private final Map<String, Set<String>> packageDeps = new HashMap<String, Set<String>>();
    private final ModuleLogger analyzerLogger;

    public ResultCollector(ModuleLogger analyzerLogger) {
        this.analyzerLogger = analyzerLogger;
    }

    public Set<String> getDependencies() {
        return this.classes;
    }

    public Map<String, Set<String>> getPackageDeps() {
        return this.packageDeps;
    }

    public void addName(String packageName, String name) {
        if (name == null) {
            return;
        }
        if (name.startsWith("[L") && name.endsWith(";")) {
            name = name.substring(2, name.length() - 1);
        }
        name = name.replace('/', '.');
        this.classes.add(name);
        this.addPackageDependency(packageName, name);
    }

    private void addPackageDependency(String packageName, String name) {
        String depPackageName;
        if (name.startsWith("java.")) {
            return;
        }
        Set<String> deps = this.packageDeps.get(packageName);
        if (deps == null) {
            deps = new HashSet<String>();
            this.packageDeps.put(packageName, deps);
        }
        if (!(packageName.equals(depPackageName = DefaultModuleApiAnalyzer.getPackageName(name)) || "".equals(depPackageName) || deps.contains(depPackageName))) {
            this.analyzerLogger.log("Adding dependency from " + packageName + " to " + depPackageName);
            deps.add(depPackageName);
        }
    }

    void addDesc(String packageName, String desc) {
        this.addType(packageName, Type.getType((String)desc));
    }

    void addType(String packageName, Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(packageName, t.getElementType());
                break;
            }
            case 10: {
                this.addName(packageName, t.getClassName().replace('.', '/'));
                break;
            }
        }
    }

    public void add(String packageName, String name) {
        this.classes.add(name);
        this.addPackageDependency(packageName, name);
    }

    void addNames(String packageName, String[] names) {
        if (names == null) {
            return;
        }
        for (String name : names) {
            this.addName(packageName, name);
        }
    }

    void addMethodDesc(String packageName, String desc) {
        Type[] types;
        this.addType(packageName, Type.getReturnType((String)desc));
        for (Type type : types = Type.getArgumentTypes((String)desc)) {
            this.addType(packageName, type);
        }
    }
}

