/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.module.analyze;

import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.tools.maven.plugin.module.analyze.ModuleApiAnalyzerException;
import org.mule.tools.maven.plugin.module.analyze.ProjectAnalysisResult;
import org.mule.tools.maven.plugin.module.analyze.SilentAnalyzerLogger;
import org.mule.tools.maven.plugin.module.analyze.VerboseAnalyzerLogger;
import org.mule.tools.maven.plugin.module.common.AbstractModuleMojo;
import org.mule.tools.maven.plugin.module.common.ModuleLogger;

@Mojo(name="analyze", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.VALIDATE)
public class AnalyzeMojo
extends AbstractModuleMojo {
    public static final String NO_MODULE_API_PROBLEMS_FOUND = "No module API problems found";
    public static final String MODULE_API_PROBLEMS_FOUND = "Module API problems found";
    public static final String PACKAGES_TO_EXPORT_ERROR = "Packages that must be exported:";
    public static final String PRIVILEGED_PACKAGES_TO_EXPORT_ERROR = "Privileged packages that must be exported:";
    public static final String NOT_ANALYZED_PACKAGES_ERROR = "Following packages were not analyzed:";
    public static final String NOT_ANALYZED_PRIVILEGED_PACKAGES_ERROR = "Following privileged packages were not analyzed:";
    public static final String DUPLICATED_EXPORTED_PACKAGES = "Following packages are already exported by a module dependency:";
    public static final String DUPLICATED_PRIVILEGED_EXPORTED_PACKAGES = "Following privileged packages are already exported by a module dependency:";
    @Parameter(property="muleModule.analyze.verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="muleModule.analyze.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping pom project");
            return;
        }
        boolean error = this.checkModuleApi();
        if (error) {
            throw new MojoExecutionException(MODULE_API_PROBLEMS_FOUND);
        }
        this.getLog().info((CharSequence)NO_MODULE_API_PROBLEMS_FOUND);
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    private boolean checkModuleApi() throws MojoExecutionException {
        ProjectAnalysisResult analysis;
        try {
            ModuleLogger analyzerLogger = this.verbose ? new VerboseAnalyzerLogger(this.getLog()) : new SilentAnalyzerLogger();
            analysis = this.analyzer.analyze(this.project, analyzerLogger, this.getLog());
        }
        catch (ModuleApiAnalyzerException exception) {
            throw new MojoExecutionException("Cannot analyze module API", (Exception)exception);
        }
        boolean stardardApiError = false;
        boolean privilegedApiError = false;
        if (analysis.getStandardApi() != null) {
            stardardApiError = this.processStandardApiResult(analysis);
        }
        if (analysis.getPrivilegedAPi() != null) {
            privilegedApiError = this.processPrivilegedApiResult(analysis);
        }
        return stardardApiError || privilegedApiError;
    }

    private boolean processStandardApiResult(ProjectAnalysisResult analysis) {
        boolean error = false;
        Map<String, Set<String>> undeclaredExportedPackages = analysis.getStandardApi().getUndeclaredPackageDeps();
        Set<String> packagesToExport = analysis.getStandardApi().getPackagesToExport();
        Set<String> noAnalyzedPackages = analysis.getStandardApi().getNotAnalyzedPackages();
        Set<String> duplicatedPackages = analysis.getStandardApi().getDuplicatedPackages();
        if (!undeclaredExportedPackages.isEmpty()) {
            this.getLog().info((CharSequence)"Used undeclared exported packages found:");
            if (this.verbose) {
                this.logUnExportedDependenciesPerPackage(analysis.getStandardApi().getUndeclaredPackageDeps());
            }
            error = true;
        }
        if (!noAnalyzedPackages.isEmpty()) {
            this.getLog().info((CharSequence)AnalyzeMojo.buildPackageErrorMessage(NOT_ANALYZED_PACKAGES_ERROR, noAnalyzedPackages));
            error = true;
        }
        if (!packagesToExport.isEmpty()) {
            this.getLog().info((CharSequence)AnalyzeMojo.buildPackageErrorMessage(PACKAGES_TO_EXPORT_ERROR, packagesToExport));
            error = true;
        }
        if (!duplicatedPackages.isEmpty()) {
            this.getLog().info((CharSequence)AnalyzeMojo.buildPackageErrorMessage(DUPLICATED_EXPORTED_PACKAGES, duplicatedPackages));
            error = true;
        }
        return error;
    }

    private boolean processPrivilegedApiResult(ProjectAnalysisResult analysis) {
        boolean error = false;
        Map<String, Set<String>> undeclaredExportedPackages = analysis.getPrivilegedAPi().getUndeclaredPackageDeps();
        Set<String> packagesToExport = analysis.getPrivilegedAPi().getPackagesToExport();
        Set<String> noAnalyzedPackages = analysis.getPrivilegedAPi().getNotAnalyzedPackages();
        Set<String> duplicatedPackages = analysis.getPrivilegedAPi().getDuplicatedPackages();
        if (!undeclaredExportedPackages.isEmpty()) {
            this.getLog().info((CharSequence)"Used undeclared privileged exported packages found:");
            if (this.verbose) {
                this.logUnExportedDependenciesPerPackage(analysis.getPrivilegedAPi().getUndeclaredPackageDeps());
            }
            error = true;
        }
        if (!noAnalyzedPackages.isEmpty()) {
            this.getLog().info((CharSequence)AnalyzeMojo.buildPackageErrorMessage(NOT_ANALYZED_PRIVILEGED_PACKAGES_ERROR, noAnalyzedPackages));
            error = true;
        }
        if (!packagesToExport.isEmpty()) {
            this.getLog().info((CharSequence)AnalyzeMojo.buildPackageErrorMessage(PRIVILEGED_PACKAGES_TO_EXPORT_ERROR, packagesToExport));
            error = true;
        }
        if (!duplicatedPackages.isEmpty()) {
            this.getLog().info((CharSequence)AnalyzeMojo.buildPackageErrorMessage(DUPLICATED_PRIVILEGED_EXPORTED_PACKAGES, duplicatedPackages));
            error = true;
        }
        return error;
    }

    private void logUnExportedDependenciesPerPackage(Map<String, Set<String>> artifacts) {
        if (artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"   None");
        } else {
            for (String exportedPackageName : artifacts.keySet()) {
                StringBuilder builder = new StringBuilder();
                builder.append("Undeclared exported packages for ").append(exportedPackageName).append(":\n");
                Set<String> undeclaredExportedPackages = artifacts.get(exportedPackageName);
                if (undeclaredExportedPackages == null || undeclaredExportedPackages.isEmpty()) {
                    builder.append("NONE");
                    continue;
                }
                for (String undeclaredExportedPackage : undeclaredExportedPackages) {
                    builder.append(undeclaredExportedPackage).append("\n");
                }
                this.getLog().info((CharSequence)builder.toString());
            }
        }
    }

    private static String buildPackageErrorMessage(String message, Set<String> packageNames) {
        StringBuilder builder = new StringBuilder();
        builder.append(message);
        for (String packageName : packageNames) {
            builder.append(System.lineSeparator()).append(packageName);
        }
        return builder.toString();
    }

    private static String buildNotAnalyzedPackageError(Set<String> packageNames) {
        return AnalyzeMojo.buildPackageErrorMessage(NOT_ANALYZED_PACKAGES_ERROR, packageNames);
    }
}

