/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.structure;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.mule.tools.api.packager.structure.FolderNames;

public class ProjectStructure {
    private final Path projectBaseFolder;
    private final Path projectBuildDirectory;

    public ProjectStructure(Path projectBaseFolder) {
        this(projectBaseFolder, Paths.get(FolderNames.TARGET.value(), new String[0]));
    }

    public ProjectStructure(Path projectBaseFolder, Path projectBuildFolder) {
        Preconditions.checkArgument((projectBaseFolder != null ? 1 : 0) != 0, (Object)"Project base folder should not be null");
        Preconditions.checkArgument((projectBuildFolder != null ? 1 : 0) != 0, (Object)"Project build folder should not be null");
        this.projectBaseFolder = projectBaseFolder;
        this.projectBuildDirectory = projectBuildFolder;
    }

    public Path getProjectBaseFolder() {
        return this.projectBaseFolder;
    }

    public Path getResourcesPath() {
        return this.projectBaseFolder.resolve(FolderNames.SRC.value()).resolve(FolderNames.MAIN.value()).resolve(FolderNames.RESOURCES.value());
    }

    public Path getConfigsPath() {
        return this.projectBaseFolder.resolve(FolderNames.SRC.value()).resolve(FolderNames.MAIN.value()).resolve(FolderNames.APP.value());
    }

    public Path getTestConfigsPath() {
        return this.projectBaseFolder.resolve(FolderNames.SRC.value()).resolve(FolderNames.TEST.value()).resolve(FolderNames.MUNIT.value());
    }

    public Path getTestResourcesPath() {
        return this.projectBaseFolder.resolve(FolderNames.SRC.value()).resolve(FolderNames.TEST.value()).resolve(FolderNames.RESOURCES.value());
    }

    public Path getMuleDeployPropertiesPath() {
        return this.getConfigsPath().resolve("mule-deploy.properties");
    }

    public Path getProjectBuildDirectory() {
        return this.projectBuildDirectory;
    }

    public Path getApiFolder() {
        return this.projectBaseFolder.resolve(FolderNames.SRC.value()).resolve(FolderNames.MAIN.value()).resolve(FolderNames.API.value());
    }

    public Path getWsdlFolder() {
        return this.projectBaseFolder.resolve(FolderNames.SRC.value()).resolve(FolderNames.MAIN.value()).resolve(FolderNames.WSDL.value());
    }

    public Path getMappingsFolder() {
        return this.projectBaseFolder.resolve(FolderNames.MAPPINGS.value());
    }
}

