/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation.project;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.packaging.Classifier;
import org.mule.tools.api.packager.packaging.PackagingType;

public abstract class AbstractProjectValidator {
    public static final String VALIDATE_GOAL = "validate";
    protected final ProjectInformation projectInformation;

    public AbstractProjectValidator(ProjectInformation projectInformation) {
        this.projectInformation = projectInformation;
        Preconditions.checkState((projectInformation.getPackaging() != null ? 1 : 0) != 0, (Object)"Packaging type should not be null");
    }

    protected abstract void additionalValidation() throws ValidationException;

    public Boolean isProjectValid(String goal) throws ValidationException {
        if (StringUtils.equals((CharSequence)VALIDATE_GOAL, (CharSequence)goal)) {
            AbstractProjectValidator.isPackagingTypeValid(this.projectInformation.getPackaging());
            this.additionalValidation();
        }
        return true;
    }

    public static Boolean isPackagingTypeValid(String packagingType) throws ValidationException {
        try {
            PackagingType.fromString(packagingType);
        }
        catch (IllegalArgumentException e) {
            ArrayList packagingTypeNames = Lists.newArrayList();
            for (int i = 0; i < PackagingType.values().length; ++i) {
                packagingTypeNames.add(PackagingType.values()[i].toString());
            }
            throw new ValidationException(packagingType == null ? e.getMessage() : "Unknown packaging type " + packagingType + ". Please specify a valid mule packaging type: " + StringUtils.join((Object[])new Object[]{", ", packagingTypeNames}));
        }
        return true;
    }

    public static Boolean isClassifierValid(String classifier) throws ValidationException {
        HashSet allClassifiers = Sets.newHashSet();
        for (int i = 0; i < Classifier.values().length; ++i) {
            allClassifiers.add(Classifier.values()[i].toString());
        }
        if (classifier == null || !allClassifiers.contains(classifier)) {
            ArrayList classifierNames = Lists.newArrayList((Iterable)allClassifiers);
            throw new ValidationException("Unknown classifier type " + classifier + ". Please specify a valid mule classifier type: " + StringUtils.join((Object[])new Object[]{", ", classifierNames}));
        }
        return true;
    }
}

