/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.filter.prefix;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.mule.tools.api.packager.filter.prefix.PrefixTreeNode;

class PrefixTree {
    protected PrefixTreeNode root = new PrefixTreeNode();
    private static final Character END_OF_PREFIX = Character.valueOf('#');

    protected PrefixTree(Collection<String> prefixes) {
        Preconditions.checkArgument((prefixes != null ? 1 : 0) != 0, (Object)"Prefixes collection should not be null");
        for (String prefix : prefixes) {
            this.addPrefix(prefix);
        }
    }

    protected PrefixTree() {
    }

    protected void addPrefix(String prefix) {
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"Prefix should not be null");
        PrefixTreeNode current = this.root;
        char[] cArray = prefix.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            current = current.addChild(c);
        }
        current.addChild(END_OF_PREFIX);
    }

    protected boolean containsPrefixOf(String input) {
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"Input should not be null");
        PrefixTreeNode current = this.root;
        for (int i = 0; i < input.length() && current.hasChild(Character.valueOf(input.charAt(i))) && !current.hasChild(END_OF_PREFIX); ++i) {
            current = current.getChild(Character.valueOf(input.charAt(i)));
        }
        return current.hasChild(END_OF_PREFIX);
    }
}

