/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.resources;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.filter.DependenciesFilter;
import org.mule.tools.api.packager.packaging.Exclusion;
import org.mule.tools.api.packager.packaging.Inclusion;
import org.mule.tools.api.packager.sources.ContentGenerator;
import org.mule.tools.api.packager.structure.FolderNames;
import org.mule.tools.api.util.Artifact;

public class MuleResourcesGenerator {
    private final DependenciesFilter dependenciesFilter;
    private final ProjectInformation projectInformation;

    public MuleResourcesGenerator(Set<Artifact> projectArtifacts, List<? extends Exclusion> excludes, List<? extends Inclusion> includes, boolean excludeMuleArtifacts, ProjectInformation projectInformation) {
        this.dependenciesFilter = new DependenciesFilter(projectArtifacts, includes, excludes, excludeMuleArtifacts);
        this.projectInformation = projectInformation;
    }

    public void generate(boolean prependGroupId) throws IOException {
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.LIB.value());
        for (Artifact artifact : this.dependenciesFilter.getArtifactsToArchive()) {
            this.copyArtifact(artifact, destinationPath, prependGroupId);
        }
    }

    private void copyArtifact(Artifact artifact, Path destinationPath, boolean prependGroupId) throws IOException {
        Path originPath = artifact.getFile().toPath();
        String filename = this.filenameInArchive(artifact, prependGroupId);
        ContentGenerator.copyFile(originPath, destinationPath, filename);
    }

    private String filenameInArchive(Artifact artifact, boolean prependGroupId) {
        StringBuilder buf = new StringBuilder();
        if (prependGroupId) {
            buf.append(artifact.getGroupId());
            buf.append(".");
        }
        buf.append(artifact.getFile().getName());
        return buf.toString();
    }
}

