/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.builder;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.archiver.ArchiverException;
import org.mule.tools.api.packager.archiver.MuleArchiver;
import org.mule.tools.api.packager.builder.PackageBuilder;
import org.mule.tools.api.packager.structure.FolderNames;

public class MulePackageBuilder
implements PackageBuilder {
    private File classesFolder = null;
    private File testClassesFolder = null;
    private File muleFolder = null;
    private File testMuleFolder = null;
    private File libFolder = null;
    protected List<File> rootResources = new ArrayList<File>();
    private MuleArchiver archiver = null;
    private File apiFolder;
    private File wsdlFolder;
    private File mappingsFolder;
    private File metaInfFolder;

    protected MulePackageBuilder withClasses(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        Preconditions.checkArgument((boolean)folder.exists(), (Object)"The folder must exists");
        this.classesFolder = folder;
        return this;
    }

    protected MulePackageBuilder withTestClasses(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        Preconditions.checkArgument((boolean)folder.exists(), (Object)"The folder must exist");
        this.testClassesFolder = folder;
        return this;
    }

    protected MulePackageBuilder withRootResource(File resource) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"The resource must not be null");
        Preconditions.checkArgument((boolean)resource.exists(), (Object)"The resource must exist");
        this.rootResources.add(resource);
        return this;
    }

    protected MulePackageBuilder withArchiver(MuleArchiver archiver) {
        Preconditions.checkArgument((archiver != null ? 1 : 0) != 0, (Object)"The archiver must not be null");
        this.archiver = archiver;
        return this;
    }

    protected MulePackageBuilder withMuleFolder(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        Preconditions.checkArgument((boolean)folder.exists(), (Object)"The folder must exist");
        this.muleFolder = folder;
        return this;
    }

    protected MulePackageBuilder withTestMuleFolder(File folder) {
        this.testMuleFolder = folder;
        return this;
    }

    protected MulePackageBuilder withApiFolder(File folder) {
        this.apiFolder = folder;
        return this;
    }

    protected MulePackageBuilder withWsdlFolder(File folder) {
        this.wsdlFolder = folder;
        return this;
    }

    protected MulePackageBuilder withLibFolder(File folder) {
        this.libFolder = folder;
        return this;
    }

    protected MulePackageBuilder withMappingsFolder(File folder) {
        this.mappingsFolder = folder;
        return this;
    }

    protected MulePackageBuilder withMetaInfFolder(File folder) {
        this.metaInfFolder = folder;
        return this;
    }

    @Override
    public void createPackage(Path originFolderPath, Path destinationPath) throws ArchiverException, IOException {
        Preconditions.checkArgument((originFolderPath != null ? 1 : 0) != 0, (Object)"The origin path must not be null");
        Preconditions.checkArgument((boolean)originFolderPath.toFile().exists(), (Object)"The origin path must exists");
        this.withClasses(originFolderPath.resolve(FolderNames.CLASSES.value()).toFile()).withTestClasses(originFolderPath.resolve(FolderNames.TEST_CLASSES.value()).toFile()).withMuleFolder(originFolderPath.resolve(FolderNames.MULE.value()).toFile()).withTestMuleFolder(originFolderPath.resolve(FolderNames.TEST_MULE.value()).toFile()).withApiFolder(originFolderPath.resolve(FolderNames.API.value()).toFile()).withWsdlFolder(originFolderPath.resolve(FolderNames.WSDL.value()).toFile()).withLibFolder(originFolderPath.resolve(FolderNames.LIB.value()).toFile()).withMappingsFolder(originFolderPath.resolve(FolderNames.MAPPINGS.value()).toFile()).withMetaInfFolder(originFolderPath.resolve(FolderNames.META_INF.value()).toFile());
        this.createArchive(destinationPath);
    }

    @Override
    public void createPackage(Path destinationPath) throws ArchiverException, IOException {
        this.createArchive(destinationPath);
    }

    private void createArchive(Path destinationPath) throws IOException {
        Preconditions.checkArgument((destinationPath != null ? 1 : 0) != 0, (Object)"The destination path must not be null");
        Preconditions.checkArgument((!destinationPath.toFile().exists() ? 1 : 0) != 0, (Object)"The destination file must not be duplicated");
        MuleArchiver archiver = this.getArchiver();
        archiver.addToRoot(this.muleFolder, null, null);
        archiver.addClasses(this.classesFolder, null, null);
        archiver.addApi(this.apiFolder, null, null);
        archiver.addWsdl(this.wsdlFolder, null, null);
        archiver.addLib(this.libFolder, null, null);
        archiver.addMappings(this.mappingsFolder, null, null);
        archiver.addMetaInf(this.metaInfFolder, null, null);
        archiver.setDestFile(destinationPath.toFile());
        archiver.createArchive();
    }

    private void validateState() {
        this.isValidFolder(this.classesFolder, "The classes folder has not been defined");
        this.isValidFolder(this.testClassesFolder, "The test-classes folder has not been defined");
    }

    private void isValidFolder(File file, String message) {
        Preconditions.checkState((file != null && file.exists() && file.isDirectory() ? 1 : 0) != 0, (Object)message);
    }

    protected MuleArchiver getArchiver() {
        if (this.archiver == null) {
            this.archiver = new MuleArchiver();
        }
        return this.archiver;
    }
}

