/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.packaging;

import com.google.common.base.CaseFormat;

public enum Classifier {
    MULE,
    MULE_DOMAIN,
    MULE_APPLICATION,
    MULE_APPLICATION_EXAMPLE,
    MULE_APPLICATION_TEMPLATE;


    public static Classifier fromString(String name) {
        String classifierName = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, name);
        return Classifier.valueOf(classifierName);
    }

    public boolean equals(String name) {
        Classifier other;
        if (name == null) {
            return false;
        }
        try {
            other = Classifier.fromString(name);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return other != null && other.equals((Object)this);
    }

    public String toString() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
    }
}

