/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.packaging;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.mule.tools.api.packager.packaging.Classifier;
import org.mule.tools.api.packager.structure.FolderNames;

public enum PackagingType {
    MULE(Classifier.MULE){

        @Override
        public Classifier[] getClassifiers() {
            return new Classifier[]{Classifier.MULE, Classifier.MULE_APPLICATION, Classifier.MULE_APPLICATION_TEMPLATE, Classifier.MULE_APPLICATION_EXAMPLE};
        }
    }
    ,
    MULE_DOMAIN(Classifier.MULE_DOMAIN){

        @Override
        public Classifier[] getClassifiers() {
            return new Classifier[]{Classifier.MULE_DOMAIN};
        }
    };

    protected Classifier defaultClassifier;

    private PackagingType(Classifier defaultClassifier) {
        this.defaultClassifier = defaultClassifier;
    }

    public abstract Classifier[] getClassifiers();

    public String resolveClassifier(String classifierName) {
        for (Classifier classifier : this.getClassifiers()) {
            if (!classifier.equals(classifierName)) continue;
            return classifierName;
        }
        return this.defaultClassifier.toString();
    }

    public static PackagingType fromString(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Packaging type name should not be null");
        String packagingName = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, name);
        return PackagingType.valueOf(packagingName);
    }

    public boolean equals(String name) {
        return name != null && PackagingType.fromString(name).equals((Object)this);
    }

    public String toString() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
    }

    public Path getSourceFolderLocation(Path projectBaseFolder) {
        return Paths.get(this.mainFolder(projectBaseFolder).getAbsolutePath(), this.getSourceFolderName());
    }

    public Path getTestSourceFolderLocation(Path projectBaseFolder) {
        return this.testFolder(projectBaseFolder).toPath().resolve(this.getTestFolderName());
    }

    public String getTestFolderName() {
        return FolderNames.MUNIT.value();
    }

    public String getSourceFolderName() {
        return FolderNames.APP.value();
    }

    private File mainFolder(Path projectBaseFolder) {
        return Paths.get(this.srcFolder(projectBaseFolder).getAbsolutePath(), FolderNames.MAIN.value()).toFile();
    }

    private File testFolder(Path projectBaseFolder) {
        return Paths.get(this.srcFolder(projectBaseFolder).getAbsolutePath(), FolderNames.TEST.value()).toFile();
    }

    private File srcFolder(Path projectBaseFolder) {
        Preconditions.checkArgument((projectBaseFolder != null ? 1 : 0) != 0, (Object)"Project base folder should not be null");
        return Paths.get(projectBaseFolder.toFile().getAbsolutePath(), FolderNames.SRC.value()).toFile();
    }
}

