/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.resources;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.filter.DependenciesFilter;
import org.mule.tools.api.packager.packaging.Exclusion;
import org.mule.tools.api.packager.packaging.Inclusion;
import org.mule.tools.api.packager.sources.ContentGenerator;
import org.mule.tools.api.packager.structure.FolderNames;
import org.mule.tools.api.packager.structure.MuleExportProperties;
import org.mule.tools.api.util.Artifact;
import org.mule.tools.api.util.ZipArchiver;

public class MuleResourcesGenerator {
    public static final String[] BLACK_LIST = new String[]{".DS_STORE", "target"};
    private final DependenciesFilter dependenciesFilter;
    private final ProjectInformation projectInformation;
    private final Boolean attachMuleSources;

    public MuleResourcesGenerator(Set<Artifact> projectArtifacts, List<? extends Exclusion> excludes, List<? extends Inclusion> includes, boolean excludeMuleArtifacts, ProjectInformation projectInformation, boolean attachMuleSources) {
        this.dependenciesFilter = new DependenciesFilter(projectArtifacts, includes, excludes, excludeMuleArtifacts);
        this.projectInformation = projectInformation;
        this.attachMuleSources = attachMuleSources;
    }

    public void generate(boolean prependGroupId) throws IOException {
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.LIB.value());
        for (Artifact artifact : this.dependenciesFilter.getArtifactsToArchive()) {
            this.copyArtifact(artifact, destinationPath, prependGroupId);
        }
        if (this.attachMuleSources.booleanValue()) {
            File metaInfFolder = this.createMetaInfFolderInTarget();
            File projectBaseFolder = this.projectInformation.getProjectBaseFolder().toFile();
            this.generateExportedZipFile(metaInfFolder, projectBaseFolder);
            String projectName = projectBaseFolder.getName();
            this.generateMuleExportProperties(metaInfFolder, projectName);
        }
    }

    private void copyArtifact(Artifact artifact, Path destinationPath, boolean prependGroupId) throws IOException {
        Path originPath = artifact.getFile().toPath();
        String filename = this.filenameInArchive(artifact, prependGroupId);
        ContentGenerator.copyFile(originPath, destinationPath, filename);
    }

    private String filenameInArchive(Artifact artifact, boolean prependGroupId) {
        StringBuilder buf = new StringBuilder();
        if (prependGroupId) {
            buf.append(artifact.getGroupId());
            buf.append(".");
        }
        buf.append(artifact.getFile().getName());
        return buf.toString();
    }

    private File createMetaInfFolderInTarget() {
        File metaInfFolder = this.projectInformation.getBuildDirectory().resolve(FolderNames.META_INF.value()).toFile();
        metaInfFolder.mkdir();
        return metaInfFolder;
    }

    protected void generateExportedZipFile(File metaInfFolder, File projectBaseFolder) throws IOException {
        ZipArchiver archiver = this.getZipArchiver();
        String output = metaInfFolder.getAbsolutePath() + File.separator + projectBaseFolder.getName() + ".zip";
        try {
            archiver.toZip(projectBaseFolder, output);
        }
        catch (IOException e) {
            throw new IOException("Could not create exportable zip file", e);
        }
    }

    protected void generateMuleExportProperties(File metaInfFolder, String projectName) throws IOException {
        MuleExportProperties exportProperties = new MuleExportProperties(projectName);
        try {
            exportProperties.store(metaInfFolder);
        }
        catch (IOException e) {
            throw new IOException("Could not create mule_export.properties", e);
        }
    }

    public ZipArchiver getZipArchiver() {
        return new ZipArchiver(BLACK_LIST);
    }
}

