/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.filter.predicate;

import java.util.Collection;
import java.util.List;
import org.mule.tools.api.packager.filter.predicate.ArtifactPredicate;
import org.mule.tools.api.packager.filter.prefix.PrefixMatcher;
import org.mule.tools.api.util.Artifact;

public abstract class AbstractArtifactPrefixPredicate
implements ArtifactPredicate {
    protected PrefixMatcher matcher;

    public AbstractArtifactPrefixPredicate(Collection<String> prefixes) {
        this.matcher = new PrefixMatcher(prefixes);
    }

    @Override
    public abstract boolean test(Artifact var1);

    public static class OnlyDependenciesTrailFilterPredicate
    extends AbstractArtifactPrefixPredicate {
        public OnlyDependenciesTrailFilterPredicate(Collection<String> prefixes) {
            super(prefixes);
        }

        @Override
        public boolean test(Artifact artifact) {
            return !this.matcher.anyMatches(artifact.getOnlyDependenciesTrail());
        }
    }

    public static class NotOptionalTrailFilterPredicate
    extends AbstractArtifactPrefixPredicate {
        public NotOptionalTrailFilterPredicate(Collection<String> prefixes) {
            super(prefixes);
        }

        @Override
        public boolean test(Artifact artifact) {
            return this.matcher.anyMatches(artifact.getDependencyTrail()) && !artifact.isOptional();
        }
    }

    public static class TrailFilterPredicate
    extends AbstractArtifactPrefixPredicate {
        public TrailFilterPredicate(List<String> exclusionPrefixes) {
            super(exclusionPrefixes);
        }

        @Override
        public boolean test(Artifact artifact) {
            return !this.matcher.anyMatches(artifact.getDependencyTrail());
        }
    }
}

