/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.sources;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.packager.sources.ContentGenerator;
import org.mule.tools.api.packager.structure.FolderNames;
import org.mule.tools.api.util.CopyFileVisitor;
import org.mule.tools.api.util.exclude.MuleExclusionMatcher;

public class MuleContentGenerator
extends ContentGenerator {
    public MuleContentGenerator(ProjectInformation projectInformation) {
        super(projectInformation);
    }

    @Override
    public void createContent() throws IOException {
        this.createDescriptors();
    }

    public void createMuleSrcFolderContent() throws IOException {
        Path originPath = PackagingType.fromString(this.projectInformation.getPackaging()).getSourceFolderLocation(this.projectInformation.getProjectBaseFolder());
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.MULE.value());
        this.copyContent(originPath, destinationPath, null, true, false);
    }

    public void createTestFolderContent() throws IOException {
        Path originPath = PackagingType.fromString(this.projectInformation.getPackaging()).getTestSourceFolderLocation(this.projectInformation.getProjectBaseFolder());
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.TEST_MULE.value()).resolve(originPath.getFileName());
        this.copyContent(originPath, destinationPath, null, false, true);
    }

    public void createApiContent() throws IOException {
        Path originPath = this.projectInformation.getProjectStructure().getApiFolder();
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.API.value());
        this.copyContent(originPath, destinationPath, null, false, true);
    }

    public void createWsdlContent() throws IOException {
        Path originPath = this.projectInformation.getProjectStructure().getWsdlFolder();
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.WSDL.value());
        this.copyContent(originPath, destinationPath, null, false, true);
    }

    public void createMappingsContent() throws IOException {
        Path originPath = this.projectInformation.getProjectStructure().getMappingsFolder();
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.MAPPINGS.value());
        this.copyContent(originPath, destinationPath, null, false, true);
    }

    private void copyContent(Path originPath, Path destinationPath, List<Path> exclusions) throws IOException {
        this.copyContent(originPath, destinationPath, exclusions, true, true);
    }

    private void copyContent(Path originPath, Path destinationPath, List<Path> exclusions, Boolean validateOrigin, Boolean validateDestination) throws IOException {
        this.copyContent(originPath, destinationPath, exclusions, validateOrigin, validateDestination, Boolean.FALSE, Boolean.FALSE);
    }

    private void copyContent(Path originPath, Path destinationPath, List<Path> exclusions, Boolean validateOrigin, Boolean validateDestination, Boolean ignoreHiddenFiles, Boolean ignoreHiddenFolders) throws IOException {
        if (validateOrigin.booleanValue()) {
            MuleContentGenerator.checkPathExist(originPath);
        }
        if (validateDestination.booleanValue()) {
            MuleContentGenerator.checkPathExist(destinationPath);
        }
        CopyFileVisitor visitor = new CopyFileVisitor(originPath.toFile(), destinationPath.toFile(), ignoreHiddenFiles, ignoreHiddenFolders, new MuleExclusionMatcher(this.projectInformation.getProjectBaseFolder()));
        if (exclusions != null) {
            visitor.setExclusions(exclusions);
        }
        Files.walkFileTree(originPath, visitor);
    }

    public void createDescriptors() throws IOException {
        this.copyDescriptorFile();
    }

    private void copyDescriptorFile() throws IOException {
        Path originPath = this.projectInformation.getProjectStructure().getMuleDeployPropertiesPath();
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.MULE.value());
        String destinationFileName = originPath.getFileName().toString();
        MuleContentGenerator.copyFile(originPath, destinationPath, destinationFileName);
    }
}

