/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.SharedLibraryDependency;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.validation.AbstractProjectValidator;
import org.mule.tools.api.validation.MuleArtifactJsonValidator;
import org.mule.tools.model.Deployment;

public class MuleProjectValidator
extends AbstractProjectValidator {
    private static final int MULE_PROJECT_MAXIMUM_NUMBER_OF_DOMAINS = 1;
    private final List<SharedLibraryDependency> sharedLibraries;
    private final Deployment deploymentConfiguration;

    public MuleProjectValidator(ProjectInformation projectInformation, List<SharedLibraryDependency> sharedLibraries, Deployment deploymentConfiguration) {
        super(projectInformation);
        this.sharedLibraries = sharedLibraries;
        this.deploymentConfiguration = deploymentConfiguration;
    }

    @Override
    protected void additionalValidation() throws ValidationException {
        MuleProjectValidator.isProjectStructureValid(this.projectInformation.getPackaging(), this.projectInformation.getProjectBaseFolder());
        this.validateDescriptorFile(this.projectInformation.getProjectBaseFolder(), this.deploymentConfiguration);
        this.validateSharedLibraries(this.sharedLibraries, this.projectInformation.getProject().getDependencies());
        this.validateReferencedDomainsIfPresent(this.projectInformation.getProject().getDependencies());
    }

    protected void validateDescriptorFile(Path projectBaseDir, Deployment deploymentConfiguration) throws ValidationException {
        MuleArtifactJsonValidator.validate(projectBaseDir, deploymentConfiguration);
    }

    protected void validateReferencedDomainsIfPresent(List<ArtifactCoordinates> dependencies) throws ValidationException {
        Preconditions.checkArgument((dependencies != null ? 1 : 0) != 0, (Object)"List of dependencies should not be null");
        Set<ArtifactCoordinates> domains = dependencies.stream().filter(d -> StringUtils.equals((CharSequence)PackagingType.MULE_DOMAIN.toString(), (CharSequence)d.getClassifier())).collect(Collectors.toSet());
        this.validateDomain(domains);
    }

    protected void validateDomain(Set<ArtifactCoordinates> domains) throws ValidationException {
        Preconditions.checkArgument((domains != null ? 1 : 0) != 0, (Object)"Set of domains should not be null");
        if (!domains.stream().allMatch(artifactCoordinates -> StringUtils.equals((CharSequence)artifactCoordinates.getClassifier(), (CharSequence)PackagingType.MULE_DOMAIN.toString()))) {
            String message = "Not all dependencies are mule domains";
            throw new ValidationException(message);
        }
        if (domains.size() > 1) {
            String message = "A mule project of type " + this.projectInformation.getPackaging() + " should reference at most " + 1 + ". However, the project has references to the following domains: " + domains.stream().collect(Collectors.toList());
            throw new ValidationException(message);
        }
        for (ArtifactCoordinates domain : domains) {
            if (StringUtils.equals((CharSequence)"provided", (CharSequence)domain.getScope())) continue;
            throw new ValidationException("A mule-domain dependency should have the <provided> scope");
        }
    }

    public static void isProjectStructureValid(String packagingType, Path projectBaseDir) throws ValidationException {
        File mainSrcApplication = MuleProjectValidator.mainSrcApplication(packagingType, projectBaseDir);
        if (!mainSrcApplication.exists()) {
            throw new ValidationException("The folder " + mainSrcApplication.getAbsolutePath() + " is mandatory");
        }
    }

    public void validateSharedLibraries(List<SharedLibraryDependency> sharedLibraries, List<ArtifactCoordinates> projectDependencies) throws ValidationException {
        Set sharedLibrariesCoordinates;
        Set projectDependenciesCoordinates;
        if (sharedLibraries != null && sharedLibraries.size() != 0 && !(projectDependenciesCoordinates = projectDependencies.stream().map(coordinate -> coordinate.getArtifactId() + ":" + coordinate.getGroupId()).collect(Collectors.toSet())).containsAll(sharedLibrariesCoordinates = sharedLibraries.stream().map(sharedLibrary -> sharedLibrary.getArtifactId() + ":" + sharedLibrary.getGroupId()).collect(Collectors.toSet()))) {
            sharedLibrariesCoordinates.removeAll(projectDependenciesCoordinates);
            throw new ValidationException("The mule application does not contain the following shared libraries: " + sharedLibrariesCoordinates.toString());
        }
    }

    private static File mainSrcApplication(String packagingType, Path projectBaseDir) throws ValidationException {
        return PackagingType.fromString(packagingType).getSourceFolderLocation(projectBaseDir).toFile();
    }
}

