/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.sources;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.tools.api.packager.sources.MuleArtifactContentResolver;
import org.mule.tools.api.packager.structure.ProjectStructure;

public class DefaultValuesMuleArtifactJsonGenerator {
    private static final MuleApplicationModelJsonSerializer serializer = new MuleApplicationModelJsonSerializer();
    private static final String MULE_ID = "mule";

    public static void generate(MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        Path muleArtifactJsonLocation = DefaultValuesMuleArtifactJsonGenerator.resolveMuleArtifactJsonLocation(muleArtifactContentResolver.getProjectStructure());
        DefaultValuesMuleArtifactJsonGenerator.generate(muleArtifactJsonLocation, muleArtifactJsonLocation, muleArtifactContentResolver);
    }

    protected static Path resolveMuleArtifactJsonLocation(ProjectStructure projectStructure) {
        return projectStructure.getMuleArtifactJsonPath();
    }

    public static void generate(Path originFolder, Path destinationFolder, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleApplicationModel originalMuleArtifact = DefaultValuesMuleArtifactJsonGenerator.getOriginalMuleArtifact(originFolder);
        MuleApplicationModel generatedMuleArtifact = DefaultValuesMuleArtifactJsonGenerator.generateMuleArtifactWithDefaultValues(originalMuleArtifact, muleArtifactContentResolver);
        DefaultValuesMuleArtifactJsonGenerator.writeMuleArtifactToFile(generatedMuleArtifact, destinationFolder);
    }

    protected static void writeMuleArtifactToFile(MuleApplicationModel muleArtifact, Path destinationFolder) throws IOException {
        String generatedMuleArtifactJsonContent = serializer.serialize((AbstractMuleArtifactModel)muleArtifact);
        File generatedMuleArtifactJson = new File(destinationFolder.toFile(), "mule-artifact.json");
        FileUtils.writeStringToFile((File)generatedMuleArtifactJson, (String)generatedMuleArtifactJsonContent, (String)null);
    }

    protected static MuleApplicationModel getOriginalMuleArtifact(Path originFolder) throws IOException {
        File originalMuleArtifactJsonFile = originFolder.resolve("mule-artifact.json").toFile();
        return (MuleApplicationModel)serializer.deserialize(FileUtils.readFileToString((File)originalMuleArtifactJsonFile, (String)null));
    }

    protected static MuleApplicationModel generateMuleArtifactWithDefaultValues(MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleApplicationModel.MuleApplicationModelBuilder builder = DefaultValuesMuleArtifactJsonGenerator.getBuilderWithRequiredValues(originalMuleArtifact);
        DefaultValuesMuleArtifactJsonGenerator.setBuilderWithDefaultValuesNotPresent(builder, originalMuleArtifact, muleArtifactContentResolver);
        return (MuleApplicationModel)builder.build();
    }

    protected static void setBuilderWithDefaultValuesNotPresent(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        DefaultValuesMuleArtifactJsonGenerator.setBuilderWithDefaultRedeploymentEnabled(builder, originalMuleArtifact);
        DefaultValuesMuleArtifactJsonGenerator.setBuilderWithDefaultConfigsValue(builder, originalMuleArtifact, muleArtifactContentResolver);
        DefaultValuesMuleArtifactJsonGenerator.setBuilderWithDefaultExportedResourcesValue(builder, muleArtifactContentResolver);
        DefaultValuesMuleArtifactJsonGenerator.setBuilderWithIncludeTestDependencies(builder, muleArtifactContentResolver);
        DefaultValuesMuleArtifactJsonGenerator.setBuilderWithDefaultSecureProperties(builder, originalMuleArtifact);
    }

    protected static void setBuilderWithIncludeTestDependencies(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleArtifactLoaderDescriptor descriptorLoader = builder.getClassLoaderModelDescriptorLoader();
        if (muleArtifactContentResolver.getProjectStructure().getTestConfigsPath().isPresent()) {
            Map<String, Object> attributesCopy = DefaultValuesMuleArtifactJsonGenerator.getUpdatedAttributes(descriptorLoader, "includeTestDependencies", "true");
            builder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(descriptorLoader.getId(), attributesCopy));
        }
    }

    protected static void setBuilderWithDefaultSecureProperties(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact) {
        ArrayList secureProperties = originalMuleArtifact.getSecureProperties();
        if (secureProperties == null) {
            secureProperties = new ArrayList();
        }
        builder.setSecureProperties((List)secureProperties);
    }

    protected static void setBuilderWithDefaultExportedResourcesValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleArtifactLoaderDescriptor descriptorLoader = builder.getClassLoaderModelDescriptorLoader();
        List<String> exportedResources = muleArtifactContentResolver.getExportedResources();
        exportedResources.addAll(muleArtifactContentResolver.getTestExportedResources());
        Map<String, Object> attributesCopy = DefaultValuesMuleArtifactJsonGenerator.getUpdatedAttributes(descriptorLoader, "exportedResources", exportedResources);
        builder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(descriptorLoader.getId(), attributesCopy));
    }

    protected static void setBuilderWithDefaultExportedPackagesValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleArtifactLoaderDescriptor descriptorLoader = builder.getClassLoaderModelDescriptorLoader();
        Map<String, Object> attributesCopy = DefaultValuesMuleArtifactJsonGenerator.getUpdatedAttributes(descriptorLoader, "exportedPackages", muleArtifactContentResolver.getExportedPackages());
        builder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(descriptorLoader.getId(), attributesCopy));
    }

    private static Map<String, Object> getUpdatedAttributes(MuleArtifactLoaderDescriptor descriptorLoader, String attribute, Object value) {
        Map originalAttributes = descriptorLoader.getAttributes();
        HashMap<String, Object> attributesCopy = new HashMap<String, Object>();
        if (originalAttributes != null) {
            attributesCopy.putAll(originalAttributes);
        }
        attributesCopy.put(attribute, value);
        return attributesCopy;
    }

    protected static void setBuilderWithDefaultConfigsValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        List<String> configs;
        try {
            Field configsField = originalMuleArtifact.getClass().getSuperclass().getDeclaredField("configs");
            configsField.setAccessible(true);
            Set configSet = (Set)configsField.get(originalMuleArtifact);
            configs = configSet != null ? new ArrayList<String>(configSet) : null;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            configs = muleArtifactContentResolver.getConfigs();
        }
        if (configs == null) {
            configs = muleArtifactContentResolver.getConfigs();
        }
        configs.addAll(muleArtifactContentResolver.getTestConfigs());
        builder.setConfigs(new HashSet<String>(configs));
    }

    protected static void setBuilderWithDefaultRedeploymentEnabled(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact) {
        builder.setRedeploymentEnabled(originalMuleArtifact.isRedeploymentEnabled());
    }

    protected static void setBuilderWithDefaultBundleDescriptorLoaderValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact) {
        MuleArtifactLoaderDescriptor bundleDescriptorLoader = originalMuleArtifact.getBundleDescriptorLoader();
        builder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor(MULE_ID, bundleDescriptorLoader == null || bundleDescriptorLoader.getAttributes() == null ? new HashMap() : bundleDescriptorLoader.getAttributes()));
    }

    protected static MuleApplicationModel.MuleApplicationModelBuilder getBuilderWithRequiredValues(MuleApplicationModel muleArtifact) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = new MuleApplicationModel.MuleApplicationModelBuilder();
        builder.setName(muleArtifact.getName());
        builder.withClassLoaderModelDescriptorLoader(muleArtifact.getClassLoaderModelLoaderDescriptor());
        builder.setMinMuleVersion(muleArtifact.getMinMuleVersion());
        builder.setRequiredProduct(muleArtifact.getRequiredProduct());
        DefaultValuesMuleArtifactJsonGenerator.setBuilderWithDefaultBundleDescriptorLoaderValue(builder, muleArtifact);
        return builder;
    }
}

