/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.sources;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.tools.api.packager.sources.MuleArtifactContentResolver;
import org.mule.tools.api.packager.structure.ProjectStructure;

public class DefaultValuesMuleArtifactJsonGenerator {
    private static final MuleApplicationModelJsonSerializer serializer = new MuleApplicationModelJsonSerializer();
    private static final String MULE_ID = "mule";
    public static final String EXPORTED_PACKAGES = "exportedPackages";
    public static final String EXPORTED_RESOURCES = "exportedResources";
    public static final String COMPILED_JAVA_EXTENSION = "class";

    public static void generate(MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        Path muleArtifactJsonLocation = DefaultValuesMuleArtifactJsonGenerator.resolveMuleArtifactJsonLocation(muleArtifactContentResolver.getProjectStructure());
        DefaultValuesMuleArtifactJsonGenerator.generate(muleArtifactJsonLocation, muleArtifactJsonLocation, muleArtifactContentResolver);
    }

    protected static Path resolveMuleArtifactJsonLocation(ProjectStructure projectStructure) {
        return projectStructure.getMuleArtifactJsonPath();
    }

    public static void generate(Path originFolder, Path destinationFolder, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleApplicationModel originalMuleArtifact = DefaultValuesMuleArtifactJsonGenerator.getOriginalMuleArtifact(originFolder);
        MuleApplicationModel generatedMuleArtifact = DefaultValuesMuleArtifactJsonGenerator.generateMuleArtifactWithDefaultValues(originalMuleArtifact, muleArtifactContentResolver);
        DefaultValuesMuleArtifactJsonGenerator.writeMuleArtifactToFile(generatedMuleArtifact, destinationFolder);
    }

    protected static void writeMuleArtifactToFile(MuleApplicationModel muleArtifact, Path destinationFolder) throws IOException {
        String generatedMuleArtifactJsonContent = serializer.serialize((AbstractMuleArtifactModel)muleArtifact);
        File generatedMuleArtifactJson = new File(destinationFolder.toFile(), "mule-artifact.json");
        FileUtils.writeStringToFile((File)generatedMuleArtifactJson, (String)generatedMuleArtifactJsonContent, (String)null);
    }

    protected static MuleApplicationModel getOriginalMuleArtifact(Path originFolder) throws IOException {
        File originalMuleArtifactJsonFile = originFolder.resolve("mule-artifact.json").toFile();
        return (MuleApplicationModel)serializer.deserialize(FileUtils.readFileToString((File)originalMuleArtifactJsonFile, (String)null));
    }

    protected static MuleApplicationModel generateMuleArtifactWithDefaultValues(MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleApplicationModel.MuleApplicationModelBuilder builder = DefaultValuesMuleArtifactJsonGenerator.getBuilderWithRequiredValues(originalMuleArtifact);
        DefaultValuesMuleArtifactJsonGenerator.setBuilderWithDefaultValuesNotPresent(builder, originalMuleArtifact, muleArtifactContentResolver);
        return (MuleApplicationModel)builder.build();
    }

    protected static void setBuilderWithDefaultValuesNotPresent(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        DefaultValuesMuleArtifactJsonGenerator.setBuilderWithDefaultRedeploymentEnabled(builder, originalMuleArtifact);
        DefaultValuesMuleArtifactJsonGenerator.setBuilderWithDefaultConfigsValue(builder, originalMuleArtifact, muleArtifactContentResolver);
        DefaultValuesMuleArtifactJsonGenerator.setBuilderWithDefaultExportedResourcesValue(builder, originalMuleArtifact, muleArtifactContentResolver);
        DefaultValuesMuleArtifactJsonGenerator.setBuilderWithIncludeTestDependencies(builder, muleArtifactContentResolver);
    }

    protected static void setBuilderWithIncludeTestDependencies(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleArtifactLoaderDescriptor descriptorLoader = builder.getClassLoaderModelDescriptorLoader();
        if (muleArtifactContentResolver.getProjectStructure().getTestConfigsPath().isPresent()) {
            Map<String, Object> attributesCopy = DefaultValuesMuleArtifactJsonGenerator.getUpdatedAttributes(descriptorLoader, "includeTestDependencies", "true");
            builder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(descriptorLoader.getId(), attributesCopy));
        }
    }

    protected static void setBuilderWithDefaultExportedResourcesValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor;
        if (originalMuleArtifact.getClassLoaderModelLoaderDescriptor() != null) {
            Map originalAttributes = originalMuleArtifact.getClassLoaderModelLoaderDescriptor().getAttributes();
            ArrayList<String> exportedResources = new ArrayList<String>();
            if (originalAttributes != null && originalAttributes.get(EXPORTED_RESOURCES) != null) {
                exportedResources.addAll((Collection)originalAttributes.get(EXPORTED_RESOURCES));
            } else {
                exportedResources.addAll(muleArtifactContentResolver.getExportedResources());
                exportedResources.addAll(muleArtifactContentResolver.getTestExportedResources());
            }
            Map<String, Object> attributesCopy = DefaultValuesMuleArtifactJsonGenerator.getUpdatedAttributes(originalMuleArtifact.getClassLoaderModelLoaderDescriptor(), EXPORTED_RESOURCES, new ArrayList(exportedResources));
            classLoaderModelLoaderDescriptor = new MuleArtifactLoaderDescriptor(originalMuleArtifact.getClassLoaderModelLoaderDescriptor().getId(), attributesCopy);
        } else {
            Path outputDirectory = muleArtifactContentResolver.getProjectStructure().getOutputDirectory();
            List allOutputFiles = Files.walk(outputDirectory, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).collect(Collectors.toList());
            Predicate<Path> isJavaClass = path -> FilenameUtils.getExtension((String)path.toString()).endsWith(COMPILED_JAVA_EXTENSION);
            List packagesFolders = allOutputFiles.stream().filter(isJavaClass).map(path -> {
                Path parent = outputDirectory.relativize((Path)path).getParent();
                return parent != null ? parent.toString() : "";
            }).map(MuleArtifactContentResolver::escapeSlashes).distinct().collect(Collectors.toList());
            List resources = allOutputFiles.stream().filter(isJavaClass.negate()).map(path -> outputDirectory.relativize((Path)path)).map(Path::toString).map(MuleArtifactContentResolver::escapeSlashes).collect(Collectors.toList());
            resources.addAll(muleArtifactContentResolver.getTestExportedResources());
            classLoaderModelLoaderDescriptor = new MuleArtifactLoaderDescriptorBuilder().setId(MULE_ID).addProperty(EXPORTED_PACKAGES, packagesFolders).addProperty(EXPORTED_RESOURCES, resources).build();
        }
        builder.withClassLoaderModelDescriptorLoader(classLoaderModelLoaderDescriptor);
    }

    protected static void setBuilderWithDefaultExportedPackagesValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleArtifactLoaderDescriptor descriptorLoader = builder.getClassLoaderModelDescriptorLoader();
        Map<String, Object> attributesCopy = DefaultValuesMuleArtifactJsonGenerator.getUpdatedAttributes(descriptorLoader, EXPORTED_PACKAGES, muleArtifactContentResolver.getExportedPackages());
        builder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(descriptorLoader.getId(), attributesCopy));
    }

    private static Map<String, Object> getUpdatedAttributes(MuleArtifactLoaderDescriptor descriptorLoader, String attribute, Object value) {
        Map originalAttributes = descriptorLoader.getAttributes();
        HashMap<String, Object> attributesCopy = new HashMap<String, Object>();
        if (originalAttributes != null) {
            attributesCopy.putAll(originalAttributes);
        }
        attributesCopy.put(attribute, value);
        return attributesCopy;
    }

    protected static void setBuilderWithDefaultConfigsValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        HashSet<String> configs = new HashSet<String>();
        if (originalMuleArtifact.getConfigs() != null) {
            configs.addAll(originalMuleArtifact.getConfigs());
        } else {
            configs.addAll(muleArtifactContentResolver.getConfigs());
        }
        configs.addAll(muleArtifactContentResolver.getTestConfigs());
        builder.setConfigs(configs);
    }

    protected static void setBuilderWithDefaultRedeploymentEnabled(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact) {
        builder.setRedeploymentEnabled(originalMuleArtifact.isRedeploymentEnabled());
    }

    protected static void setBuilderWithDefaultBundleDescriptorLoaderValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact) {
        MuleArtifactLoaderDescriptor bundleDescriptorLoader = originalMuleArtifact.getBundleDescriptorLoader();
        builder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor(MULE_ID, bundleDescriptorLoader == null || bundleDescriptorLoader.getAttributes() == null ? new HashMap() : bundleDescriptorLoader.getAttributes()));
    }

    protected static MuleApplicationModel.MuleApplicationModelBuilder getBuilderWithRequiredValues(MuleApplicationModel muleArtifact) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = new MuleApplicationModel.MuleApplicationModelBuilder();
        builder.setName(muleArtifact.getName());
        builder.setMinMuleVersion(muleArtifact.getMinMuleVersion());
        builder.setRequiredProduct(muleArtifact.getRequiredProduct());
        builder.setSecureProperties(muleArtifact.getSecureProperties());
        DefaultValuesMuleArtifactJsonGenerator.setBuilderWithDefaultBundleDescriptorLoaderValue(builder, muleArtifact);
        return builder;
    }
}

