/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.sources;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.mule.tools.api.packager.Pom;
import org.mule.tools.api.packager.structure.ProjectStructure;

public class MuleArtifactContentResolver {
    private static final String CONFIG_FILE_EXTENSION = ".xml";
    private final ProjectStructure projectStructure;
    private List<String> configs;
    private List<String> testConfigs;
    private List<String> exportedPackages;
    private List<String> exportedResources;
    private List<String> testExportedResources;
    private Pom pom;

    public MuleArtifactContentResolver(ProjectStructure projectStructure, Pom pom) {
        Preconditions.checkArgument((projectStructure != null ? 1 : 0) != 0, (Object)"Project structure should not be null");
        this.projectStructure = projectStructure;
        this.pom = pom;
    }

    public ProjectStructure getProjectStructure() {
        return this.projectStructure;
    }

    public List<String> getExportedPackages() throws IOException {
        if (this.exportedPackages == null) {
            this.exportedPackages = this.getResources(this.projectStructure.getExportedPackagesPath());
        }
        return this.exportedPackages;
    }

    public List<String> getExportedResources() throws IOException {
        if (this.exportedResources == null) {
            this.exportedResources = new ArrayList<String>();
            for (Path resourcePath : this.pom.getResourcesLocation()) {
                this.exportedResources.addAll(this.getResources(resourcePath));
            }
        }
        return this.exportedResources;
    }

    public List<String> getTestExportedResources() throws IOException {
        if (this.testExportedResources == null) {
            Optional<Path> testExportedResourcesPath = this.projectStructure.getTestExportedResourcesPath();
            this.testExportedResources = testExportedResourcesPath.isPresent() ? this.getResources(testExportedResourcesPath.get()) : Collections.emptyList();
        }
        return this.testExportedResources;
    }

    public List<String> getConfigs() throws IOException {
        if (this.configs == null) {
            this.configs = this.getResources(this.projectStructure.getConfigsPath(), (IOFileFilter)new SuffixFileFilter(CONFIG_FILE_EXTENSION));
        }
        return this.configs;
    }

    public List<String> getTestConfigs() throws IOException {
        if (this.testConfigs == null) {
            Optional<Path> testConfigsPath = this.projectStructure.getTestConfigsPath();
            this.testConfigs = testConfigsPath.isPresent() ? this.getResources(testConfigsPath.get(), (IOFileFilter)new SuffixFileFilter(CONFIG_FILE_EXTENSION)) : Collections.emptyList();
        }
        return this.testConfigs;
    }

    private List<String> getResources(Path resourcesFolderPath) throws IOException {
        return this.getResources(resourcesFolderPath, TrueFileFilter.INSTANCE);
    }

    private List<String> getResources(Path resourcesFolderPath, IOFileFilter fileFilter) throws IOException {
        if (resourcesFolderPath == null) {
            throw new IOException("The resources folder is invalid");
        }
        File resourcesFolder = resourcesFolderPath.toFile();
        if (!resourcesFolder.exists()) {
            return new ArrayList<String>();
        }
        Collection resourcesFolderContent = FileUtils.listFiles((File)resourcesFolder, (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
        return resourcesFolderContent.stream().filter(f -> !f.isHidden()).map(File::toPath).map(p -> resourcesFolder.toPath().relativize((Path)p)).map(Path::toString).map(MuleArtifactContentResolver::escapeSlashes).collect(Collectors.toList());
    }

    public static String escapeSlashes(String p) {
        return p.replace("\\", "/");
    }
}

