/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.sources;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.tools.api.classloader.ClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.packager.sources.ContentGenerator;
import org.mule.tools.api.packager.sources.DefaultValuesMuleArtifactJsonGenerator;
import org.mule.tools.api.packager.sources.MuleArtifactContentResolver;
import org.mule.tools.api.packager.structure.FolderNames;
import org.mule.tools.api.packager.structure.ProjectStructure;
import org.mule.tools.api.util.CopyFileVisitor;
import org.mule.tools.api.util.exclude.MuleExclusionMatcher;

public class MuleContentGenerator
extends ContentGenerator {
    private MuleArtifactContentResolver muleArtifactContentResolver;

    public MuleContentGenerator(ProjectInformation projectInformation) {
        super(projectInformation);
    }

    @Override
    public void createContent() throws IOException {
        this.createMetaInfMuleSourceFolderContent();
        this.createDescriptors();
    }

    public void createMuleSrcFolderContent() throws IOException {
        Path originPath = PackagingType.fromString(this.projectInformation.getPackaging()).getSourceFolderLocation(this.projectInformation.getProjectBaseFolder());
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.CLASSES.value());
        this.copyContent(originPath, destinationPath, Optional.ofNullable(null), true, false);
    }

    public void createTestFolderContent() throws IOException {
        Path originPath = PackagingType.fromString(this.projectInformation.getPackaging()).getTestSourceFolderLocation(this.projectInformation.getProjectBaseFolder());
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.TEST_MULE.value()).resolve(originPath.getFileName());
        this.copyContent(originPath, destinationPath, Optional.ofNullable(null), false, true);
    }

    public void createMetaInfMuleSourceFolderContent() throws IOException {
        Path originPath = this.projectInformation.getProjectBaseFolder();
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_SRC.value()).resolve(this.projectInformation.getArtifactId());
        ArrayList<Path> exclusions = new ArrayList<Path>();
        exclusions.add(this.projectInformation.getBuildDirectory());
        this.copyContent(originPath, destinationPath, Optional.of(exclusions), true, true, true, true);
    }

    public void createApplicationClassLoaderModelJsonFile(ClassLoaderModel classLoaderModel) {
        File destinationFolder = this.projectInformation.getBuildDirectory().resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value()).toFile();
        MuleContentGenerator.createClassLoaderModelJsonFile(classLoaderModel, destinationFolder);
    }

    public static ClassLoaderModel createClassLoaderModelFromJson(File classLoaderModelDescriptor) {
        return ClassLoaderModelJsonSerializer.deserialize((File)classLoaderModelDescriptor);
    }

    private void copyContent(Path originPath, Path destinationPath, Optional<List<Path>> exclusions) throws IOException {
        this.copyContent(originPath, destinationPath, exclusions, true, true);
    }

    private void copyContent(Path originPath, Path destinationPath, Optional<List<Path>> exclusions, Boolean validateOrigin, Boolean validateDestination) throws IOException {
        this.copyContent(originPath, destinationPath, exclusions, validateOrigin, validateDestination, Boolean.FALSE, Boolean.FALSE);
    }

    private void copyContent(Path originPath, Path destinationPath, Optional<List<Path>> exclusions, Boolean validateOrigin, Boolean validateDestination, Boolean ignoreHiddenFiles, Boolean ignoreHiddenFolders) throws IOException {
        if (validateOrigin.booleanValue()) {
            MuleContentGenerator.checkPathExist(originPath);
        }
        if (validateDestination.booleanValue()) {
            MuleContentGenerator.checkPathExist(destinationPath);
        }
        CopyFileVisitor visitor = new CopyFileVisitor(originPath.toFile(), destinationPath.toFile(), ignoreHiddenFiles, ignoreHiddenFolders, new MuleExclusionMatcher(this.projectInformation.getProjectBaseFolder()));
        exclusions.ifPresent(e -> visitor.setExclusions((List<Path>)e));
        Files.walkFileTree(originPath, visitor);
    }

    public static File createClassLoaderModelJsonFile(ClassLoaderModel classLoaderModel, File destinationFolder) {
        return ClassLoaderModelJsonSerializer.serializeToFile((ClassLoaderModel)classLoaderModel, (File)destinationFolder);
    }

    public void createDescriptors() throws IOException {
        this.createMavenDescriptors();
        this.createEffectivePom();
    }

    private void createEffectivePom() throws IOException {
        this.projectInformation.getEffectivePom().persist(this.projectInformation.getBuildDirectory().resolve(FolderNames.TEMP.value()).resolve(FolderNames.META_INF.value()).resolve(FolderNames.MAVEN.value()).resolve(this.projectInformation.getGroupId()).resolve(this.projectInformation.getArtifactId()).resolve("pom.xml"));
    }

    @Override
    public void copyDescriptorFile() throws IOException {
        Path originPath = this.projectInformation.getProjectBaseFolder().resolve("mule-artifact.json");
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value());
        String destinationFileName = originPath.getFileName().toString();
        MuleContentGenerator.copyFile(originPath, destinationPath, destinationFileName);
        DefaultValuesMuleArtifactJsonGenerator.generate(this.getMuleArtifactContentResolver());
    }

    public MuleArtifactContentResolver getMuleArtifactContentResolver() {
        if (this.muleArtifactContentResolver == null) {
            ProjectStructure projectStructure = new ProjectStructure(this.projectInformation.getProjectBaseFolder(), this.projectInformation.getBuildDirectory(), this.projectInformation.isTestProject());
            this.muleArtifactContentResolver = new MuleArtifactContentResolver(projectStructure, this.projectInformation.getEffectivePom());
        }
        return this.muleArtifactContentResolver;
    }
}

