/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.sources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleScope;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.runtime.internal.dsl.DslConstants;
import org.mule.tools.api.packager.Pom;
import org.mule.tools.api.packager.sources.MuleArtifactContentResolver;
import org.mule.tools.api.packager.structure.ProjectStructure;

public class DefaultValuesMuleArtifactJsonGenerator {
    private static final MuleApplicationModelJsonSerializer serializer = new MuleApplicationModelJsonSerializer();
    private static final String MULE_ID = "mule";
    public static final String EXPORTED_PACKAGES = "exportedPackages";
    public static final String EXPORTED_RESOURCES = "exportedResources";
    public static final String COMPILED_JAVA_EXTENSION = "class";

    public void generate(MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        Path muleArtifactJsonLocation = this.resolveMuleArtifactJsonLocation(muleArtifactContentResolver.getProjectStructure());
        this.generate(muleArtifactJsonLocation, muleArtifactJsonLocation, muleArtifactContentResolver);
    }

    protected Path resolveMuleArtifactJsonLocation(ProjectStructure projectStructure) {
        return projectStructure.getMuleArtifactJsonPath();
    }

    public void generate(Path originFolder, Path destinationFolder, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleApplicationModel originalMuleArtifact = this.getOriginalMuleArtifact(originFolder);
        MuleApplicationModel generatedMuleArtifact = this.generateMuleArtifactWithDefaultValues(originalMuleArtifact, muleArtifactContentResolver);
        this.writeMuleArtifactToFile(generatedMuleArtifact, destinationFolder);
    }

    protected void writeMuleArtifactToFile(MuleApplicationModel muleArtifact, Path destinationFolder) throws IOException {
        String generatedMuleArtifactJsonContent = serializer.serialize((AbstractMuleArtifactModel)muleArtifact);
        File generatedMuleArtifactJson = new File(destinationFolder.toFile(), "mule-artifact.json");
        FileUtils.writeStringToFile((File)generatedMuleArtifactJson, (String)generatedMuleArtifactJsonContent, (String)null);
    }

    protected MuleApplicationModel getOriginalMuleArtifact(Path originFolder) throws IOException {
        File originalMuleArtifactJsonFile = originFolder.resolve("mule-artifact.json").toFile();
        return (MuleApplicationModel)serializer.deserialize(FileUtils.readFileToString((File)originalMuleArtifactJsonFile, (String)null));
    }

    protected MuleApplicationModel generateMuleArtifactWithDefaultValues(MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleApplicationModel.MuleApplicationModelBuilder builder = this.getBuilderWithRequiredValues(originalMuleArtifact);
        this.setBuilderWithDefaultValuesNotPresent(builder, originalMuleArtifact, muleArtifactContentResolver);
        return (MuleApplicationModel)builder.build();
    }

    protected void setBuilderWithDefaultValuesNotPresent(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        this.setBuilderWithDefaultName(builder, originalMuleArtifact, muleArtifactContentResolver);
        this.setBuilderWithDefaultSecureProperties(builder, originalMuleArtifact);
        this.setBuilderWithDefaultRedeploymentEnabled(builder, originalMuleArtifact);
        this.setBuilderWithDefaultConfigsValue(builder, originalMuleArtifact, muleArtifactContentResolver);
        this.setBuilderWithDefaultRequiredProduct(builder, originalMuleArtifact, muleArtifactContentResolver);
        this.setBuilderWithDefaultExportedResourcesValue(builder, originalMuleArtifact, muleArtifactContentResolver);
        this.setBuilderWithIncludeTestDependencies(builder, muleArtifactContentResolver);
        this.setBuilderWithDefaultBundleDescriptorLoaderValue(builder, originalMuleArtifact);
    }

    private void setBuilderWithDefaultRequiredProduct(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        Product requiredProduct = originalMuleArtifact.getRequiredProduct();
        if (requiredProduct == null) {
            requiredProduct = Product.MULE;
            if (this.doesSomeConfigRequireEE(originalMuleArtifact, muleArtifactContentResolver) || this.anyMulePluginInDependenciesRequiresEE(muleArtifactContentResolver) || this.anyProvidedDependencyRequiresEE(muleArtifactContentResolver)) {
                requiredProduct = Product.MULE_EE;
            }
        }
        builder.setRequiredProduct(requiredProduct);
    }

    private boolean anyProvidedDependencyRequiresEE(MuleArtifactContentResolver muleArtifactContentResolver) {
        return muleArtifactContentResolver.getPom().getDependencies().stream().filter(coordinates -> StringUtils.equals((String)coordinates.getScope(), (String)"provided")).anyMatch(coordinates -> coordinates.getGroupId().startsWith("com.mulesoft.mule"));
    }

    private boolean anyMulePluginInDependenciesRequiresEE(MuleArtifactContentResolver muleArtifactContentResolver) {
        return muleArtifactContentResolver.getBundleDependencies().stream().filter(dep -> dep.getDescriptor().isPlugin()).filter(dep -> dep.getScope().equals((Object)BundleScope.COMPILE)).map(BundleDependency::getBundleUri).anyMatch(this::mulePluginRequiresEE);
    }

    private boolean mulePluginRequiresEE(URI uri) {
        try {
            JarFile pluginJar = new JarFile(uri.getPath());
            JarEntry muleArtifactDescriptor = pluginJar.getJarEntry("META-INF/mule-artifact/mule-artifact.json");
            InputStream is = pluginJar.getInputStream(muleArtifactDescriptor);
            String muleArtifactJson = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            MuleApplicationModel mulePluginApplicationModel = (MuleApplicationModel)serializer.deserialize(muleArtifactJson);
            Product requiredProduct = mulePluginApplicationModel.getRequiredProduct();
            return requiredProduct != null && requiredProduct.equals((Object)Product.MULE_EE);
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean doesSomeConfigRequireEE(MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        Set configs = this.getConfigs(originalMuleArtifact, muleArtifactContentResolver).stream().map(config -> muleArtifactContentResolver.getProjectStructure().getConfigsPath().resolve((String)config)).collect(Collectors.toSet());
        return configs.stream().map(this::toDocument).anyMatch(this::containsEENamespace);
    }

    private boolean containsEENamespace(Document doc) {
        Element root = doc.getRootElement();
        return root.getNamespace().getURI().contains(DslConstants.EE_NAMESPACE) || doc.getRootElement().getAdditionalNamespaces().stream().anyMatch(n -> n.getURI().contains(DslConstants.EE_NAMESPACE));
    }

    private Document toDocument(Path filePath) {
        SAXBuilder saxBuilder = new SAXBuilder();
        try {
            return saxBuilder.build(filePath.toFile());
        }
        catch (IOException | JDOMException e) {
            return new Document();
        }
    }

    protected void setBuilderWithDefaultSecureProperties(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact) {
        ArrayList secureProperties = originalMuleArtifact.getSecureProperties();
        if (secureProperties == null) {
            secureProperties = new ArrayList();
        }
        builder.setSecureProperties((List)secureProperties);
    }

    protected void setBuilderWithDefaultName(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) {
        String name = originalMuleArtifact.getName();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)name)) {
            Pom pom = muleArtifactContentResolver.getPom();
            name = pom.getGroupId() + ":" + pom.getArtifactId() + ":" + pom.getVersion();
        }
        builder.setName(name);
    }

    protected void setBuilderWithIncludeTestDependencies(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleArtifactLoaderDescriptor descriptorLoader = builder.getClassLoaderModelDescriptorLoader();
        if (muleArtifactContentResolver.getProjectStructure().getTestConfigsPath().isPresent()) {
            Map<String, Object> attributesCopy = this.getUpdatedAttributes(descriptorLoader, "includeTestDependencies", "true");
            builder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(descriptorLoader.getId(), attributesCopy));
        }
    }

    protected void setBuilderWithDefaultExportedResourcesValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor;
        if (originalMuleArtifact.getClassLoaderModelLoaderDescriptor() != null) {
            Map originalAttributes = originalMuleArtifact.getClassLoaderModelLoaderDescriptor().getAttributes();
            ArrayList<String> exportedResources = new ArrayList<String>();
            if (originalAttributes != null && originalAttributes.get(EXPORTED_RESOURCES) != null) {
                exportedResources.addAll((Collection)originalAttributes.get(EXPORTED_RESOURCES));
            } else {
                exportedResources.addAll(muleArtifactContentResolver.getExportedResources());
                exportedResources.addAll(muleArtifactContentResolver.getTestExportedResources());
            }
            Map<String, Object> attributesCopy = this.getUpdatedAttributes(originalMuleArtifact.getClassLoaderModelLoaderDescriptor(), EXPORTED_RESOURCES, new ArrayList(exportedResources));
            classLoaderModelLoaderDescriptor = new MuleArtifactLoaderDescriptor(originalMuleArtifact.getClassLoaderModelLoaderDescriptor().getId(), attributesCopy);
        } else {
            Path outputDirectory = muleArtifactContentResolver.getProjectStructure().getOutputDirectory();
            List allOutputFiles = Files.walk(outputDirectory, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).collect(Collectors.toList());
            Predicate<Path> isJavaClass = path -> FilenameUtils.getExtension((String)path.toString()).endsWith(COMPILED_JAVA_EXTENSION);
            List packagesFolders = allOutputFiles.stream().filter(isJavaClass).map(path -> {
                Path parent = outputDirectory.relativize((Path)path).getParent();
                return parent != null ? parent.toString() : "";
            }).map(MuleArtifactContentResolver::escapeSlashes).distinct().collect(Collectors.toList());
            List<String> muleConfigs = muleArtifactContentResolver.getConfigs();
            List resources = allOutputFiles.stream().filter(isJavaClass.negate()).map(path -> outputDirectory.relativize((Path)path)).map(Path::toString).map(MuleArtifactContentResolver::escapeSlashes).filter(path -> !muleConfigs.contains(path)).collect(Collectors.toList());
            resources.addAll(muleArtifactContentResolver.getTestExportedResources());
            classLoaderModelLoaderDescriptor = new MuleArtifactLoaderDescriptorBuilder().setId(MULE_ID).addProperty(EXPORTED_PACKAGES, packagesFolders).addProperty(EXPORTED_RESOURCES, resources).build();
        }
        builder.withClassLoaderModelDescriptorLoader(classLoaderModelLoaderDescriptor);
    }

    protected void setBuilderWithDefaultExportedPackagesValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleArtifactLoaderDescriptor descriptorLoader = builder.getClassLoaderModelDescriptorLoader();
        Map<String, Object> attributesCopy = this.getUpdatedAttributes(descriptorLoader, EXPORTED_PACKAGES, muleArtifactContentResolver.getExportedPackages());
        builder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(descriptorLoader.getId(), attributesCopy));
    }

    private Map<String, Object> getUpdatedAttributes(MuleArtifactLoaderDescriptor descriptorLoader, String attribute, Object value) {
        Map originalAttributes = descriptorLoader.getAttributes();
        HashMap<String, Object> attributesCopy = new HashMap<String, Object>();
        if (originalAttributes != null) {
            attributesCopy.putAll(originalAttributes);
        }
        attributesCopy.put(attribute, value);
        return attributesCopy;
    }

    protected void setBuilderWithDefaultConfigsValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        Set<String> configs = this.getConfigs(originalMuleArtifact, muleArtifactContentResolver);
        configs.addAll(muleArtifactContentResolver.getTestConfigs());
        builder.setConfigs(configs);
    }

    private Set<String> getConfigs(MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        HashSet<String> configs = new HashSet<String>();
        if (originalMuleArtifact.getConfigs() != null) {
            configs.addAll(originalMuleArtifact.getConfigs());
        } else {
            configs.addAll(muleArtifactContentResolver.getConfigs());
        }
        return configs;
    }

    protected void setBuilderWithDefaultRedeploymentEnabled(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact) {
        builder.setRedeploymentEnabled(originalMuleArtifact.isRedeploymentEnabled());
    }

    protected void setBuilderWithDefaultBundleDescriptorLoaderValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact) {
        MuleArtifactLoaderDescriptor bundleDescriptorLoader = originalMuleArtifact.getBundleDescriptorLoader();
        builder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor(MULE_ID, bundleDescriptorLoader == null || bundleDescriptorLoader.getAttributes() == null ? new HashMap() : bundleDescriptorLoader.getAttributes()));
    }

    protected MuleApplicationModel.MuleApplicationModelBuilder getBuilderWithRequiredValues(MuleApplicationModel muleArtifact) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = new MuleApplicationModel.MuleApplicationModelBuilder();
        builder.setMinMuleVersion(muleArtifact.getMinMuleVersion());
        return builder;
    }
}

