/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation.exchange;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.api.validation.exchange.ExchangeRepositoryMetadata;
import org.mule.tools.api.validation.exchange.model.Group;
import org.mule.tools.client.agent.AbstractClient;
import org.mule.tools.client.authentication.AuthenticationServiceClient;
import org.mule.tools.client.authentication.model.Credentials;

public class ExchangeClient
extends AbstractClient {
    private static final String GROUPS_PATH = "exchange/api/v1/organizations/%s/groups";
    private String bearerToken;
    private AuthenticationServiceClient authenticationServiceClient;
    private ExchangeRepositoryMetadata metadata;

    public ExchangeClient(ExchangeRepositoryMetadata metadata) {
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"The metadata must not be null");
        this.metadata = metadata;
        this.authenticationServiceClient = new AuthenticationServiceClient(metadata.getBaseUri());
    }

    public String getGeneratedGroupId() {
        this.getBearerToken(this.metadata.getCredentials());
        Response response = this.get(this.metadata.getBaseUri(), String.format(GROUPS_PATH, this.metadata.getOrganizationId()));
        this.validateStatusSuccess(response);
        Type listType = new TypeToken<ArrayList<Group>>(){}.getType();
        List groupList = (List)new Gson().fromJson((String)response.readEntity(String.class), listType);
        return ((Group)groupList.get(0)).getGroupId();
    }

    protected void configureRequest(Invocation.Builder builder) {
        if (this.bearerToken != null) {
            builder.header("Authorization", (Object)("bearer " + this.bearerToken));
        }
    }

    private String getBearerToken(Credentials credentials) {
        if (StringUtils.isBlank((CharSequence)this.bearerToken)) {
            this.bearerToken = this.authenticationServiceClient.getBearerToken(credentials);
        }
        return this.bearerToken;
    }
}

