/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader.model.util;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class ArtifactUtils {
    public static ArtifactCoordinates toArtifactCoordinates(BundleDescriptor bundleDescriptor) {
        ArtifactCoordinates artifactCoordinates = new ArtifactCoordinates(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), bundleDescriptor.getBaseVersion(), bundleDescriptor.getType(), (String)bundleDescriptor.getClassifier().orElse(null));
        return artifactCoordinates;
    }

    public static Artifact toArtifact(BundleDependency bundleDependency) {
        ArtifactCoordinates artifactCoordinates = ArtifactUtils.toArtifactCoordinates(bundleDependency.getDescriptor());
        return new Artifact(artifactCoordinates, bundleDependency.getBundleUri());
    }

    public static List<Artifact> toArtifacts(Collection<BundleDependency> dependencies) {
        return dependencies.stream().map(ArtifactUtils::toArtifact).collect(Collectors.toList());
    }

    public static boolean isValidMulePlugin(Artifact artifact) {
        ArtifactCoordinates pluginCoordinates = artifact.getArtifactCoordinates();
        Optional<String> pluginClassifier = Optional.ofNullable(pluginCoordinates.getClassifier());
        return pluginClassifier.isPresent() && "mule-plugin".equals(pluginClassifier.get());
    }

    public static BundleDescriptor toBundleDescriptor(ArtifactCoordinates artifactCoordinates) {
        return new BundleDescriptor.Builder().setGroupId(artifactCoordinates.getGroupId()).setArtifactId(artifactCoordinates.getArtifactId()).setVersion(artifactCoordinates.getVersion()).setBaseVersion(artifactCoordinates.getVersion()).setClassifier(artifactCoordinates.getClassifier()).setType(artifactCoordinates.getType()).build();
    }
}

