/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.sources;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.tools.api.packager.Pom;
import org.mule.tools.api.packager.structure.ProjectStructure;

public class MuleArtifactContentResolver {
    private static final String CONFIG_FILE_EXTENSION = ".xml";
    public static final String CLASS_PATH_SEPARATOR = "/";
    private final ProjectStructure projectStructure;
    private List<String> configs;
    private List<String> testConfigs;
    private List<String> exportedPackages;
    private List<String> exportedResources;
    private List<String> testExportedResources;
    private Pom pom;
    private List<BundleDependency> bundleDependencies;

    public MuleArtifactContentResolver(ProjectStructure projectStructure, Pom pom, List<BundleDependency> bundleDependencies) {
        Preconditions.checkArgument((projectStructure != null ? 1 : 0) != 0, (Object)"Project structure should not be null");
        this.projectStructure = projectStructure;
        this.pom = pom;
        this.bundleDependencies = bundleDependencies;
    }

    public ProjectStructure getProjectStructure() {
        return this.projectStructure;
    }

    public List<String> getExportedPackages() throws IOException {
        if (this.exportedPackages == null) {
            this.exportedPackages = this.getResources(this.projectStructure.getExportedPackagesPath());
        }
        return this.exportedPackages;
    }

    public List<String> getExportedResources() throws IOException {
        if (this.exportedResources == null) {
            this.exportedResources = new ArrayList<String>();
            for (Path resourcePath : this.pom.getResourcesLocation()) {
                this.exportedResources.addAll(this.getResources(resourcePath));
            }
        }
        return this.exportedResources;
    }

    public List<String> getTestExportedResources() throws IOException {
        if (this.testExportedResources == null) {
            Optional<Path> testExportedResourcesPath = this.projectStructure.getTestExportedResourcesPath();
            this.testExportedResources = testExportedResourcesPath.isPresent() ? this.getResources(testExportedResourcesPath.get()) : Collections.emptyList();
        }
        return this.testExportedResources;
    }

    public List<String> getConfigs() throws IOException {
        if (this.configs == null) {
            List<String> candidateConfigs = this.getResources(this.projectStructure.getConfigsPath(), (IOFileFilter)new SuffixFileFilter(CONFIG_FILE_EXTENSION));
            this.configs = candidateConfigs.stream().filter(config -> this.hasMuleAsRootElement(this.projectStructure.getConfigsPath().resolve((String)config))).collect(Collectors.toList());
        }
        return this.configs;
    }

    private boolean hasMuleAsRootElement(Path path) {
        Document doc;
        try {
            doc = this.generateDocument(path);
        }
        catch (IOException | JDOMException e) {
            return false;
        }
        return this.hasMuleAsRootElement(doc);
    }

    protected boolean hasMuleAsRootElement(Document doc) {
        if (doc != null && doc.getRootElement() != null) {
            String rootElementName = doc.getRootElement().getName();
            return StringUtils.equals((CharSequence)rootElementName, (CharSequence)"mule") || StringUtils.equals((CharSequence)rootElementName, (CharSequence)"mule-domain");
        }
        return false;
    }

    private Document generateDocument(Path filePath) throws JDOMException, IOException {
        SAXBuilder saxBuilder = new SAXBuilder();
        return saxBuilder.build(filePath.toFile());
    }

    public List<String> getTestConfigs() throws IOException {
        if (this.testConfigs == null) {
            Optional<Path> testConfigsPath = this.projectStructure.getTestConfigsPath();
            this.testConfigs = Collections.emptyList();
            if (testConfigsPath.isPresent()) {
                List<String> candidateTestConfigs = this.getResources(testConfigsPath.get(), (IOFileFilter)new SuffixFileFilter(CONFIG_FILE_EXTENSION));
                this.testConfigs = candidateTestConfigs.stream().filter(testConfig -> this.hasMuleAsRootElement(this.projectStructure.getTestConfigsPath().get().resolve((String)testConfig))).collect(Collectors.toList());
            }
        }
        return this.testConfigs;
    }

    private List<String> getResources(Path resourcesFolderPath) throws IOException {
        return this.getResources(resourcesFolderPath, TrueFileFilter.INSTANCE);
    }

    private List<String> getResources(Path resourcesFolderPath, IOFileFilter fileFilter) throws IOException {
        if (resourcesFolderPath == null) {
            throw new IOException("The resources folder is invalid");
        }
        File resourcesFolder = resourcesFolderPath.toFile();
        if (!resourcesFolder.exists()) {
            return new ArrayList<String>();
        }
        Collection resourcesFolderContent = FileUtils.listFiles((File)resourcesFolder, (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
        return resourcesFolderContent.stream().filter(f -> !f.isHidden()).map(File::toPath).map(p -> resourcesFolder.toPath().relativize((Path)p)).map(Path::toString).map(MuleArtifactContentResolver::escapeSlashes).collect(Collectors.toList());
    }

    public static String escapeSlashes(String p) {
        return p.replace("\\", CLASS_PATH_SEPARATOR);
    }

    public List<BundleDependency> getBundleDependencies() {
        return this.bundleDependencies;
    }

    public Pom getPom() {
        return this.pom;
    }
}

