/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.mule.tools.api.util.exclude.MuleExclusionMatcher;

public class CopyFileVisitor
implements FileVisitor<Path> {
    private final File fromFolder;
    private final File targetFolder;
    private Boolean ignoreHiddenFiles;
    private Boolean ignoreHiddenFolders;
    private List<Path> exclusions = Collections.emptyList();
    private PathMatcher exclusionMatcher;

    public CopyFileVisitor(File fromFolder, File targetFolder) throws IOException {
        this(fromFolder, targetFolder, Boolean.FALSE, Boolean.FALSE, new MuleExclusionMatcher());
    }

    public CopyFileVisitor(File fromFolder, File targetFolder, Boolean ignoreHiddenFiles, Boolean ignoreHiddenFolders) throws IOException {
        this(fromFolder, targetFolder, ignoreHiddenFiles, ignoreHiddenFolders, new MuleExclusionMatcher());
    }

    public CopyFileVisitor(File fromFolder, File targetFolder, Boolean ignoreHiddenFiles, Boolean ignoreHiddenFolders, PathMatcher exclusionMatcher) throws IOException {
        this.fromFolder = fromFolder;
        this.targetFolder = targetFolder;
        this.ignoreHiddenFiles = ignoreHiddenFiles;
        this.ignoreHiddenFolders = ignoreHiddenFolders;
        this.exclusionMatcher = exclusionMatcher;
    }

    public void setExclusions(List<Path> exclusions) {
        this.exclusions = exclusions;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.exclusionMatcher.matches(dir) || this.exclusions.contains(dir) || this.ignoreHiddenFolders.booleanValue() && dir.toFile().isHidden()) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        Path targetPath = this.targetFolder.toPath().resolve(this.fromFolder.toPath().relativize(dir));
        if (!Files.exists(targetPath, new LinkOption[0])) {
            Files.createDirectory(targetPath, new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.exclusionMatcher.matches(file) || this.ignoreHiddenFiles.booleanValue() && file.toFile().isHidden()) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        Files.copy(file, this.targetFolder.toPath().resolve(this.fromFolder.toPath().relativize(file)), StandardCopyOption.REPLACE_EXISTING);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

