/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader.model.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.classloader.model.resolver.Plugin;
import org.mule.tools.api.classloader.model.util.ArtifactUtils;

public class AdditionalPluginDependenciesResolver {
    private AetherMavenClient aetherMavenClient;
    private List<Plugin> pluginsWithAdditionalDependencies;

    public AdditionalPluginDependenciesResolver(AetherMavenClient muleMavenPluginClient, List<Plugin> additionalPluginDependencies) {
        this.aetherMavenClient = muleMavenPluginClient;
        this.pluginsWithAdditionalDependencies = additionalPluginDependencies;
    }

    public Map<BundleDependency, List<BundleDependency>> resolveDependencies(List<BundleDependency> mulePlugins, Collection<ClassLoaderModel> mulePluginsClassLoaderModels) {
        LinkedHashMap<BundleDependency, List<BundleDependency>> pluginsWithAdditionalDeps = new LinkedHashMap<BundleDependency, List<BundleDependency>>();
        for (Plugin pluginWithAdditionalDependencies : this.pluginsWithAdditionalDependencies) {
            BundleDependency pluginBundleDependency = this.getPluginBundleDependency(pluginWithAdditionalDependencies, mulePlugins);
            ClassLoaderModel pluginClassLoaderModel = this.getPluginClassLoaderModel(pluginWithAdditionalDependencies, mulePluginsClassLoaderModels);
            ArrayList additionalDependencies = new ArrayList();
            pluginWithAdditionalDependencies.getAdditionalDependencies().stream().filter(additionalDep -> !this.isPresentInClassLoaderModel(pluginClassLoaderModel, (Dependency)additionalDep)).forEach(dep -> additionalDependencies.addAll(this.resolveDependency((Dependency)dep)));
            if (additionalDependencies.isEmpty()) continue;
            pluginsWithAdditionalDeps.put(pluginBundleDependency, additionalDependencies);
        }
        return pluginsWithAdditionalDeps;
    }

    private List<BundleDependency> resolveDependency(Dependency dependency) {
        BundleDescriptor bundleDescriptor = ArtifactUtils.toBundleDescriptor(dependency);
        ArrayList<BundleDependency> resolvedDependencies = new ArrayList<BundleDependency>();
        resolvedDependencies.add(this.aetherMavenClient.resolveBundleDescriptor(bundleDescriptor));
        resolvedDependencies.addAll(this.aetherMavenClient.resolveBundleDescriptorDependencies(false, false, bundleDescriptor));
        return resolvedDependencies;
    }

    private BundleDependency getPluginBundleDependency(Plugin plugin, List<BundleDependency> mulePlugins) {
        return mulePlugins.stream().filter(mulePlugin -> StringUtils.equals((CharSequence)mulePlugin.getDescriptor().getArtifactId(), (CharSequence)plugin.getArtifactId()) && StringUtils.equals((CharSequence)mulePlugin.getDescriptor().getGroupId(), (CharSequence)plugin.getGroupId())).findFirst().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Declared additional dependencies for a plugin not present: " + plugin))));
    }

    private ClassLoaderModel getPluginClassLoaderModel(Plugin plugin, Collection<ClassLoaderModel> mulePluginsClassLoaderModels) {
        return mulePluginsClassLoaderModels.stream().filter(pluginClassLoaderModel -> StringUtils.equals((CharSequence)pluginClassLoaderModel.getArtifactCoordinates().getGroupId(), (CharSequence)plugin.getGroupId()) && StringUtils.equals((CharSequence)pluginClassLoaderModel.getArtifactCoordinates().getArtifactId(), (CharSequence)plugin.getArtifactId())).findFirst().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not find ClassLoaderModel resolved for plugin: " + plugin))));
    }

    private boolean areSameArtifact(Dependency dependency, Artifact artifact) {
        return StringUtils.equals((CharSequence)dependency.getArtifactId(), (CharSequence)artifact.getArtifactCoordinates().getArtifactId()) && StringUtils.equals((CharSequence)dependency.getGroupId(), (CharSequence)artifact.getArtifactCoordinates().getGroupId()) && StringUtils.equals((CharSequence)dependency.getVersion(), (CharSequence)artifact.getArtifactCoordinates().getVersion());
    }

    private boolean isPresentInClassLoaderModel(ClassLoaderModel classLoaderModel, Dependency dep) {
        return classLoaderModel.getDependencies().stream().anyMatch(artifactDependency -> this.areSameArtifact(dep, (Artifact)artifactDependency));
    }
}

