/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader.model.resolver;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.tools.api.classloader.model.Plugin;
import org.mule.tools.api.classloader.model.resolver.ClassloaderModelResolver;
import org.mule.tools.api.validation.VersionUtils;

public class MulePluginClassloaderModelResolver
extends ClassloaderModelResolver {
    private List<Plugin> pluginsWithAdditionalDependencies = new ArrayList<Plugin>();

    public MulePluginClassloaderModelResolver(AetherMavenClient muleMavenPluginClient) {
        super(muleMavenPluginClient, "mule-plugin");
    }

    public MulePluginClassloaderModelResolver(AetherMavenClient muleMavenPluginClient, List<Plugin> pluginsWithAdditionalDependencies) {
        super(muleMavenPluginClient, "mule-plugin");
        this.pluginsWithAdditionalDependencies = pluginsWithAdditionalDependencies;
    }

    @Override
    protected List<BundleDependency> resolveConflicts(List<BundleDependency> newDependencies, List<BundleDependency> alreadyResolved) {
        return this.resolveMulePluginsVersions(newDependencies, alreadyResolved);
    }

    @Override
    public Map<BundleDependency, List<BundleDependency>> resolveDependencies(List<BundleDependency> mulePlugins) {
        LinkedHashMap<BundleDependency, List<BundleDependency>> muleDependenciesDependencies = new LinkedHashMap<BundleDependency, List<BundleDependency>>();
        for (BundleDependency muleDependency : mulePlugins) {
            List mulePluginDependencies = this.muleMavenPluginClient.resolveBundleDescriptorDependencies(false, false, muleDependency.getDescriptor());
            muleDependenciesDependencies.put(muleDependency, new ArrayList(mulePluginDependencies));
        }
        return muleDependenciesDependencies;
    }

    protected List<BundleDependency> resolveMulePluginsVersions(List<BundleDependency> mulePluginsToResolve, List<BundleDependency> definitiveMulePlugins) {
        ArrayList<BundleDependency> resolvedPlugins = new ArrayList<BundleDependency>();
        Preconditions.checkArgument((mulePluginsToResolve != null ? 1 : 0) != 0, (Object)"List of mule plugins to resolve should not be null");
        Preconditions.checkArgument((definitiveMulePlugins != null ? 1 : 0) != 0, (Object)"List of definitive mule plugins should not be null");
        for (BundleDependency mulePluginToResolve : mulePluginsToResolve) {
            Optional<BundleDependency> mulePlugin = definitiveMulePlugins.stream().filter(p -> this.hasSameArtifactIdAndMajor((BundleDependency)p, mulePluginToResolve)).findFirst();
            resolvedPlugins.add(mulePlugin.orElse(mulePluginToResolve));
        }
        return resolvedPlugins;
    }

    protected boolean hasSameArtifactIdAndMajor(BundleDependency bundleDependency, BundleDependency otherBundleDependency) {
        BundleDescriptor descriptor = bundleDependency.getDescriptor();
        BundleDescriptor otherDescriptor = otherBundleDependency.getDescriptor();
        return StringUtils.equals((CharSequence)descriptor.getArtifactId(), (CharSequence)otherDescriptor.getArtifactId()) && StringUtils.equals((CharSequence)VersionUtils.getMajor(descriptor.getBaseVersion()), (CharSequence)VersionUtils.getMajor(otherDescriptor.getBaseVersion()));
    }
}

