/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.repository;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.RemoteRepository;
import org.mule.maven.client.api.model.Authentication;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.maven.client.internal.AetherMavenClientProvider;
import org.mule.maven.client.internal.DefaultLocalRepositorySupplierFactory;
import org.mule.maven.client.internal.DefaultSettingsSupplierFactory;
import org.mule.maven.client.internal.MavenEnvironmentVariables;
import org.mule.tools.api.util.PackagerLog;

public class MuleMavenPluginClientBuilder {
    private PackagerLog log;
    private List<RemoteRepository> remoteRepositories;
    private File localRepository;
    private File globalSettings;
    private File userSettings;
    private Properties userProperties;
    private List<String> activeProfiles;
    private List<String> inactiveProfiles;

    public MuleMavenPluginClientBuilder(PackagerLog log) {
        this.log = log;
    }

    public MuleMavenPluginClientBuilder withRemoteRepositories(List<RemoteRepository> remoteRepositories) {
        Preconditions.checkArgument((remoteRepositories != null ? 1 : 0) != 0, (Object)"Remote repositories list can not be null");
        this.remoteRepositories = remoteRepositories;
        return this;
    }

    public MuleMavenPluginClientBuilder withLocalRepository(File localRepository) {
        this.localRepository = localRepository;
        return this;
    }

    public MuleMavenPluginClientBuilder withGlobalSettings(File globalSettings) {
        this.globalSettings = globalSettings;
        return this;
    }

    public MuleMavenPluginClientBuilder withUserProperties(Properties userProperties) {
        this.userProperties = userProperties;
        return this;
    }

    public MuleMavenPluginClientBuilder withActiveProfiles(List<String> activeProfiles) {
        this.activeProfiles = activeProfiles;
        return this;
    }

    public MuleMavenPluginClientBuilder withInactiveProfiles(List<String> inactiveProfiles) {
        this.inactiveProfiles = inactiveProfiles;
        return this;
    }

    public MuleMavenPluginClientBuilder withUserSettings(File userSettings) {
        this.userSettings = userSettings;
        return this;
    }

    public AetherMavenClient build() {
        MavenConfiguration mavenConfiguration = this.buildMavenConfiguration();
        AetherMavenClientProvider provider = new AetherMavenClientProvider();
        return (AetherMavenClient)provider.createMavenClient(mavenConfiguration);
    }

    protected MavenConfiguration buildMavenConfiguration() {
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = new MavenConfiguration.MavenConfigurationBuilder();
        DefaultSettingsSupplierFactory settingsSupplierFactory = new DefaultSettingsSupplierFactory(new MavenEnvironmentVariables());
        Optional<File> globalSettings = this.globalSettings != null ? Optional.of(this.globalSettings) : settingsSupplierFactory.environmentGlobalSettingsSupplier();
        Optional<File> userSettings = this.userSettings != null ? Optional.of(this.userSettings) : settingsSupplierFactory.environmentUserSettingsSupplier();
        Optional securitySettings = settingsSupplierFactory.environmentSettingsSecuritySupplier();
        globalSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).globalSettingsLocation(arg_0));
        userSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).userSettingsLocation(arg_0));
        securitySettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).settingsSecurityLocation(arg_0));
        DefaultLocalRepositorySupplierFactory localRepositorySupplierFactory = new DefaultLocalRepositorySupplierFactory();
        Supplier localMavenRepository = this.localRepository != null ? () -> this.localRepository : localRepositorySupplierFactory.environmentMavenRepositorySupplier();
        this.remoteRepositories.stream().filter(this::hasValidURL).map(this::toRemoteRepo).forEach(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).remoteRepository(arg_0));
        if (this.userProperties != null) {
            mavenConfigurationBuilder.userProperties(this.userProperties);
        }
        if (this.activeProfiles != null) {
            mavenConfigurationBuilder.activeProfiles(this.activeProfiles);
        }
        if (this.inactiveProfiles != null) {
            mavenConfigurationBuilder.inactiveProfiles(this.inactiveProfiles);
        }
        return mavenConfigurationBuilder.localMavenRepositoryLocation((File)localMavenRepository.get()).build();
    }

    private boolean hasValidURL(RemoteRepository remoteRepository) {
        try {
            new URL(remoteRepository.getUrl());
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    private org.mule.maven.client.api.model.RemoteRepository toRemoteRepo(RemoteRepository remoteRepository) {
        String id = remoteRepository.getId();
        Optional<Authentication> authentication = this.getAuthentication(remoteRepository);
        URL remoteRepositoryUrl = this.getURL(remoteRepository);
        RemoteRepository.RemoteRepositoryBuilder builder = new RemoteRepository.RemoteRepositoryBuilder();
        authentication.ifPresent(arg_0 -> ((RemoteRepository.RemoteRepositoryBuilder)builder).authentication(arg_0));
        return builder.id(id).url(remoteRepositoryUrl).build();
    }

    private URL getURL(RemoteRepository remoteRepository) {
        try {
            return new URL(remoteRepository.getUrl());
        }
        catch (MalformedURLException e) {
            this.log.warn("Could not resolve remote repository URL: " + remoteRepository);
            return null;
        }
    }

    private Optional<Authentication> getAuthentication(RemoteRepository remoteRepository) {
        AuthenticationContext authenticationContext = AuthenticationContext.forRepository((RepositorySystemSession)new DefaultRepositorySystemSession(), (RemoteRepository)remoteRepository);
        if (authenticationContext == null) {
            return Optional.empty();
        }
        String password = new String((char[])authenticationContext.get("password", char[].class));
        String username = new String((char[])authenticationContext.get("username", char[].class));
        Authentication.AuthenticationBuilder authenticationBuilder = new Authentication.AuthenticationBuilder();
        AuthenticationContext.close((AuthenticationContext)authenticationContext);
        return Optional.of(authenticationBuilder.password(password).username(username).build());
    }
}

