/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader.model;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.tools.api.classloader.model.AppClassLoaderModel;
import org.mule.tools.api.classloader.model.ApplicationClassloaderModel;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.classloader.model.resolver.AdditionalPluginDependenciesResolver;
import org.mule.tools.api.classloader.model.resolver.ApplicationDependencyResolver;
import org.mule.tools.api.classloader.model.resolver.ClassloaderModelResolver;
import org.mule.tools.api.classloader.model.resolver.MulePluginClassloaderModelResolver;
import org.mule.tools.api.classloader.model.resolver.RamlClassloaderModelResolver;
import org.mule.tools.api.classloader.model.util.ArtifactUtils;
import org.mule.tools.api.classloader.model.util.PluginUtils;

public class ApplicationClassLoaderModelAssembler {
    public static final String CLASS_LOADER_MODEL_VERSION = "1.1.0";
    private ApplicationClassloaderModel applicationClassLoaderModel;
    private ApplicationDependencyResolver applicationDependencyResolver;
    private ClassloaderModelResolver mulePluginClassLoaderModelResolver;
    private ClassloaderModelResolver ramlClassLoaderModelResolver;
    private AdditionalPluginDependenciesResolver additionalPluginDependenciesResolver;

    @Deprecated
    public ApplicationClassLoaderModelAssembler(AetherMavenClient aetherMavenClient, File temporaryFolder) {
        this.applicationDependencyResolver = new ApplicationDependencyResolver(aetherMavenClient);
        this.mulePluginClassLoaderModelResolver = new MulePluginClassloaderModelResolver(aetherMavenClient);
        this.ramlClassLoaderModelResolver = new RamlClassloaderModelResolver(aetherMavenClient);
        this.additionalPluginDependenciesResolver = new AdditionalPluginDependenciesResolver(aetherMavenClient, Collections.emptyList(), temporaryFolder);
    }

    public ApplicationClassLoaderModelAssembler(ApplicationDependencyResolver applicationDependencyResolver, ClassloaderModelResolver mulePluginClassLoaderModelResolver, ClassloaderModelResolver ramlClassLoaderModelResolver, AdditionalPluginDependenciesResolver additionalPluginDependenciesResolver) {
        this.applicationDependencyResolver = applicationDependencyResolver;
        this.mulePluginClassLoaderModelResolver = mulePluginClassLoaderModelResolver;
        this.ramlClassLoaderModelResolver = ramlClassLoaderModelResolver;
        this.additionalPluginDependenciesResolver = additionalPluginDependenciesResolver;
    }

    public ApplicationClassloaderModel getApplicationClassLoaderModel(File pomFile) throws IllegalStateException {
        ArtifactCoordinates appCoordinates = this.getApplicationArtifactCoordinates(pomFile);
        AppClassLoaderModel appModel = new AppClassLoaderModel(CLASS_LOADER_MODEL_VERSION, appCoordinates);
        List<BundleDependency> appDependencies = this.applicationDependencyResolver.resolveApplicationDependencies(pomFile);
        appModel.setDependencies(ArtifactUtils.toApplicationModelArtifacts(appDependencies));
        this.applicationClassLoaderModel = new ApplicationClassloaderModel((ClassLoaderModel)appModel);
        Collection<ClassLoaderModel> pluginsClassLoaderModels = this.mulePluginClassLoaderModelResolver.resolve(appDependencies);
        this.applicationClassLoaderModel.addAllMulePluginClassloaderModels(pluginsClassLoaderModels);
        appModel.setAdditionalPluginDependencies(PluginUtils.toPluginDependencies(this.additionalPluginDependenciesResolver.resolveDependencies(appDependencies, pluginsClassLoaderModels)));
        this.applicationClassLoaderModel.addAllRamlClassloaderModels(this.ramlClassLoaderModelResolver.resolve(appDependencies));
        this.applicationClassLoaderModel.addAllRamlToApplicationClassloaderModel(this.ramlClassLoaderModelResolver.getDependencies());
        return this.applicationClassLoaderModel;
    }

    public ArtifactCoordinates getApplicationArtifactCoordinates(File pomFile) {
        return ArtifactUtils.getApplicationArtifactCoordinates(pomFile);
    }
}

