/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.repository;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.packager.sources.MuleContentGenerator;
import org.mule.tools.api.packager.structure.FolderNames;
import org.mule.tools.api.util.PackagerLog;

public class ArtifactInstaller {
    private static final String POM_FILE_NAME = "pom.xml";
    private PackagerLog log;

    public ArtifactInstaller(PackagerLog log) {
        this.log = log;
    }

    public void installArtifact(File repositoryFile, Artifact artifact, Optional<ClassLoaderModel> classLoaderModel) throws IOException {
        Preconditions.checkArgument((artifact != null ? 1 : 0) != 0, (Object)"Artifact to be installed should not be null");
        File artifactFolderDestination = artifact.getFormattedMavenDirectory(repositoryFile);
        if (!artifactFolderDestination.exists()) {
            artifactFolderDestination.mkdirs();
        }
        try {
            this.generateArtifactFile(artifact, artifactFolderDestination, repositoryFile);
            this.generateDependencyDescriptorFile(artifact, artifactFolderDestination, classLoaderModel);
        }
        catch (IOException e) {
            throw new IOException(String.format("There was a problem while copying the artifact [%s] file [%s] to the application local repository", artifact.toString(), artifact.getUri().getPath()), e);
        }
    }

    protected void generateArtifactFile(Artifact artifact, File artifactFolderDestination, File repositoryFile) throws IOException {
        String artifactFilename = artifact.getFormattedArtifactFileName();
        File destinationArtifactFile = new File(artifactFolderDestination, artifactFilename);
        this.log.debug(String.format("Adding artifact <%s%s>", FolderNames.REPOSITORY.value(), destinationArtifactFile.getAbsolutePath().replaceFirst(Pattern.quote(repositoryFile.getAbsolutePath()), "")));
        FileUtils.copyFile((File)new File(artifact.getUri()), (File)destinationArtifactFile);
    }

    protected void generateDependencyDescriptorFile(Artifact artifact, File artifactFolderDestination, Optional<ClassLoaderModel> classLoaderModel) throws IOException {
        if (classLoaderModel.isPresent()) {
            this.generateClassloderModelFile(classLoaderModel.get(), artifactFolderDestination);
        } else {
            this.generatePomFile(artifact, artifactFolderDestination);
        }
    }

    protected void generatePomFile(Artifact artifact, File artifactFolderDestination) throws IOException {
        String artifactPomFilename = artifact.getPomFileName();
        File srcPomFolder = new File(artifact.getUri()).getParentFile();
        File srcPomFile = new File(srcPomFolder, artifactPomFilename);
        File destinationPomFile = new File(artifactFolderDestination, artifactPomFilename);
        if (!srcPomFile.exists()) {
            srcPomFile = new File(srcPomFolder, POM_FILE_NAME);
        }
        FileUtils.copyFile((File)srcPomFile, (File)destinationPomFile);
    }

    protected void generateClassloderModelFile(ClassLoaderModel classLoaderModel, File artifactFolderDestination) {
        MuleContentGenerator.createClassLoaderModelJsonFile(classLoaderModel, artifactFolderDestination);
    }
}

