/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader.model.resolver;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.tools.api.classloader.model.resolver.ClassloaderModelResolver;

public class RamlClassloaderModelResolver
extends ClassloaderModelResolver {
    private static final String RAML_CLASSIFIER = "raml";
    protected Map<BundleDependency, List<BundleDependency>> muleDependenciesDependencies;
    protected Set<BundleDescriptor> visited;

    public RamlClassloaderModelResolver(AetherMavenClient muleMavenPluginClient) {
        super(muleMavenPluginClient, RAML_CLASSIFIER);
    }

    @Override
    protected List<BundleDependency> resolveConflicts(List<BundleDependency> newDependencies, List<BundleDependency> alreadyResolved) {
        return newDependencies;
    }

    @Override
    public Map<BundleDependency, List<BundleDependency>> resolveDependencies(List<BundleDependency> dependencies) {
        this.visited = new HashSet<BundleDescriptor>();
        return this.resolveRamlDependencies(dependencies);
    }

    protected Map<BundleDependency, List<BundleDependency>> resolveRamlDependencies(List<BundleDependency> ramls) {
        Preconditions.checkArgument((ramls != null ? 1 : 0) != 0, (Object)"List of bundle dependencies should not be null");
        this.muleDependenciesDependencies = new HashMap<BundleDependency, List<BundleDependency>>();
        for (BundleDependency raml : ramls) {
            if (!this.unvisited(raml)) continue;
            this.collectDependencies(raml);
        }
        return this.muleDependenciesDependencies;
    }

    protected void collectDependencies(BundleDependency raml) {
        ArrayDeque<BundleDependency> queue = new ArrayDeque<BundleDependency>();
        queue.add(raml);
        while (!queue.isEmpty()) {
            BundleDependency ramlDependency = (BundleDependency)queue.poll();
            if (this.alreadyVisited(ramlDependency)) continue;
            List<BundleDependency> ramlDependencies = this.getDependencies(ramlDependency);
            this.muleDependenciesDependencies.put(ramlDependency, new ArrayList<BundleDependency>(ramlDependencies));
            for (BundleDependency dependency : ramlDependencies) {
                if (!this.shouldVisit(dependency)) continue;
                queue.offer(dependency);
            }
            this.markVisited(ramlDependency);
        }
    }

    protected boolean shouldVisit(BundleDependency dependency) {
        Optional classifier = dependency.getDescriptor().getClassifier();
        return classifier.isPresent() && (StringUtils.equals((CharSequence)((CharSequence)classifier.get()), (CharSequence)RAML_CLASSIFIER) || StringUtils.equals((CharSequence)((CharSequence)classifier.get()), (CharSequence)"raml-fragment")) && !this.muleDependenciesDependencies.containsKey(dependency);
    }

    protected void markVisited(BundleDependency ramlDependency) {
        this.visited.add(ramlDependency.getDescriptor());
    }

    protected List<BundleDependency> getDependencies(BundleDependency ramlDependency) {
        return this.muleMavenPluginClient.resolveBundleDescriptorDependencies(false, false, ramlDependency.getDescriptor());
    }

    protected boolean alreadyVisited(BundleDependency raml) {
        return this.visited.contains(raml.getDescriptor());
    }

    protected boolean unvisited(BundleDependency raml) {
        return !this.alreadyVisited(raml);
    }
}

