/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.repository;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.api.classloader.model.ApplicationClassLoaderModelAssembler;
import org.mule.tools.api.classloader.model.ApplicationClassloaderModel;
import org.mule.tools.api.classloader.model.ApplicationGAVModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.classloader.model.NotParameterizedClassLoaderModel;
import org.mule.tools.api.packager.sources.MuleContentGenerator;
import org.mule.tools.api.packager.structure.FolderNames;
import org.mule.tools.api.repository.ArtifactInstaller;
import org.mule.tools.api.util.FileUtils;

public class RepositoryGenerator {
    private static final String PROVIDED_SCOPE = "provided";
    private final ArtifactInstaller artifactInstaller;
    private final ApplicationClassLoaderModelAssembler applicationClassLoaderModelAssembler;
    protected File outputDirectory;
    private File projectPomFile;
    private ApplicationGAVModel appGAVModel;

    public RepositoryGenerator(File projectPomFile, File outputDirectory, ArtifactInstaller artifactInstaller, ApplicationClassLoaderModelAssembler applicationClassLoaderModelAssembler, ApplicationGAVModel appGAVModel) {
        this.projectPomFile = projectPomFile;
        this.outputDirectory = outputDirectory;
        this.artifactInstaller = artifactInstaller;
        this.applicationClassLoaderModelAssembler = applicationClassLoaderModelAssembler;
        this.appGAVModel = appGAVModel;
    }

    public ClassLoaderModel generate() throws IOException, IllegalStateException {
        ApplicationClassloaderModel appModel = this.applicationClassLoaderModelAssembler.getApplicationClassLoaderModel(this.projectPomFile, this.appGAVModel);
        this.installArtifacts(this.getRepositoryFolder(), this.artifactInstaller, appModel);
        return appModel.getClassLoaderModel();
    }

    public ClassLoaderModel generate(boolean lightweight, boolean useLocalRepository) throws IOException, IllegalStateException {
        ApplicationClassloaderModel appModel = this.applicationClassLoaderModelAssembler.getApplicationClassLoaderModel(this.projectPomFile, this.appGAVModel);
        if (!lightweight) {
            this.installArtifacts(this.getRepositoryFolder(), this.artifactInstaller, appModel);
        }
        if (useLocalRepository) {
            this.generateClassLoaderModelRepositoryFiles(appModel);
        }
        return appModel.getClassLoaderModel();
    }

    private void generateClassLoaderModelRepositoryFiles(ApplicationClassloaderModel appModel) {
        appModel.getMulePluginsClassloaderModels().stream().forEach(mulePluginClassLoaderModel -> {
            Artifact artifact = appModel.getArtifacts().stream().filter(possibleArtifact -> possibleArtifact.getArtifactCoordinates().equals((Object)mulePluginClassLoaderModel.getArtifactCoordinates())).findFirst().orElseThrow(() -> new RuntimeException(String.format("Cannot resolve artifact folder for class loader model: [%s]", mulePluginClassLoaderModel.getArtifactCoordinates())));
            File artifactFolderDestination = artifact.getFormattedMavenDirectory(this.outputDirectory.toPath().resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value()).toFile());
            if (!artifactFolderDestination.exists()) {
                artifactFolderDestination.mkdirs();
            }
            MuleContentGenerator.createClassLoaderModelJsonFile((ClassLoaderModel)new NotParameterizedClassLoaderModel(mulePluginClassLoaderModel), artifactFolderDestination);
        });
    }

    public ClassLoaderModel generate(boolean lightweight) throws IOException, IllegalStateException {
        return this.generate(lightweight, false);
    }

    protected File getRepositoryFolder() {
        File repositoryFolder = new File(this.outputDirectory, FolderNames.REPOSITORY.value());
        if (!repositoryFolder.exists()) {
            repositoryFolder.mkdirs();
        }
        return repositoryFolder;
    }

    protected void installArtifacts(File repositoryFile, ArtifactInstaller installer, ApplicationClassloaderModel appModel) throws IOException {
        Map mulePluginsClassloaderModels = appModel.getMulePluginsClassloaderModels().stream().collect(Collectors.toMap(ClassLoaderModel::getArtifactCoordinates, Function.identity()));
        TreeSet<Artifact> sortedArtifacts = new TreeSet<Artifact>(this.removeProvidedArtifacts(appModel.getArtifacts()));
        if (sortedArtifacts.isEmpty()) {
            this.generateMarkerFileInRepositoryFolder(repositoryFile);
        }
        for (Artifact artifact : sortedArtifacts) {
            Optional<ClassLoaderModel> classLoaderModelOptional = Optional.ofNullable(mulePluginsClassloaderModels.get(artifact.getArtifactCoordinates()));
            installer.installArtifact(repositoryFile, artifact, classLoaderModelOptional);
        }
    }

    private Set<Artifact> removeProvidedArtifacts(Set<Artifact> artifacts) {
        return artifacts.stream().filter(artifact -> !StringUtils.equals((CharSequence)artifact.getArtifactCoordinates().getScope(), (CharSequence)PROVIDED_SCOPE)).collect(Collectors.toSet());
    }

    protected void generateMarkerFileInRepositoryFolder(File repositoryFile) throws IOException {
        File markerFile = new File(repositoryFile, ".marker");
        try {
            FileUtils.checkReadOnly(repositoryFile);
            markerFile.createNewFile();
        }
        catch (IOException e) {
            throw new IOException(String.format("The current repository has no artifacts to install, and trying to create [%s] failed", markerFile.toString()), e);
        }
    }
}

