/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.util;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.exception.ProjectBuildingException;
import org.mule.tools.api.util.ArtifactUtils;
import org.mule.tools.api.util.DependencyProject;
import org.mule.tools.api.util.Project;
import org.mule.tools.api.util.ProjectBuilder;

public class MavenProjectBuilder
implements ProjectBuilder {
    private static final String CREATION_ERROR_MESSAGE = "There was an issue while trying to create a maven project from the artifact [%s]";
    private static final String CREATION_SEVERAL_ERRORS_MESSAGE = "There was an issue while trying to create a maven project from the artifact [%s], several FATAL errors were found";
    private Log log;
    private MavenSession session;
    private org.apache.maven.project.ProjectBuilder projectBuilder;
    private RepositorySystem repositorySystem;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteArtifactRepositories;
    private ProjectBuildingRequest projectBuildingRequest;

    public MavenProjectBuilder(Log log, MavenSession session, org.apache.maven.project.ProjectBuilder projectBuilder, RepositorySystem repositorySystem, ArtifactRepository localRepository, List<ArtifactRepository> remoteArtifactRepositories) {
        this.log = log;
        this.session = session;
        this.projectBuilder = projectBuilder;
        this.repositorySystem = repositorySystem;
        this.localRepository = localRepository;
        this.remoteArtifactRepositories = remoteArtifactRepositories;
        this.initialize();
    }

    private void initialize() {
        this.projectBuildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        this.projectBuildingRequest.setLocalRepository(this.localRepository);
        this.projectBuildingRequest.setRemoteRepositories(this.remoteArtifactRepositories);
        this.log.debug((CharSequence)String.format("Local repository [%s]", this.projectBuildingRequest.getLocalRepository().getBasedir()));
        for (ArtifactRepository artifactRepository : this.projectBuildingRequest.getRemoteRepositories()) {
            this.log.debug((CharSequence)String.format("Remote repository ID [%s], URL [%s]", artifactRepository.getId(), artifactRepository.getUrl()));
        }
    }

    private MavenProject buildMavenProject(Dependency dependency) throws ProjectBuildingException {
        Artifact projectArtifact = this.repositorySystem.createProjectArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        return this.buildMavenProjectFromArtifact(projectArtifact);
    }

    private MavenProject buildMavenProjectFromArtifact(Artifact artifact) throws ProjectBuildingException {
        MavenProject mavenProject;
        try {
            Artifact projectArtifact = this.repositorySystem.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            mavenProject = this.projectBuilder.build(projectArtifact, this.projectBuildingRequest).getProject();
        }
        catch (org.apache.maven.project.ProjectBuildingException e) {
            this.log.warn((CharSequence)String.format("The artifact [%s] seems to have some warnings", artifact.toString()));
            this.log.debug((CharSequence)String.format("The artifact [%s] had the following issue ", artifact.toString()), (Throwable)e);
            mavenProject = this.buildMavenMavenProjectWithErrors(artifact, e);
        }
        return mavenProject;
    }

    private MavenProject buildMavenMavenProjectWithErrors(Artifact artifact, org.apache.maven.project.ProjectBuildingException e) throws ProjectBuildingException {
        List results = e.getResults();
        if (results == null || results.size() != 1) {
            throw new ProjectBuildingException(String.format(CREATION_ERROR_MESSAGE, artifact.toString()), e);
        }
        ProjectBuildingResult projectBuildingResult = (ProjectBuildingResult)results.get(0);
        List fatalProblems = projectBuildingResult.getProblems().stream().filter(modelProblem -> modelProblem.getSeverity().equals((Object)ModelProblem.Severity.FATAL)).collect(Collectors.toList());
        if (!fatalProblems.isEmpty()) {
            throw new ProjectBuildingException(String.format(CREATION_SEVERAL_ERRORS_MESSAGE, artifact.toString()), e);
        }
        return projectBuildingResult.getProject();
    }

    @Override
    public Project buildProject(ArtifactCoordinates artifactCoordinates) throws ProjectBuildingException {
        return new DependencyProject(this.buildMavenProject(ArtifactUtils.toDependency(artifactCoordinates)));
    }
}

