/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.sources;

import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.util.StringUtils;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleScope;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.internal.dsl.DslConstants;
import org.mule.tools.api.packager.sources.AbstractDefaultValuesMuleArtifactJsonGenerator;
import org.mule.tools.api.packager.sources.MuleArtifactContentResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DefaultValuesMuleArtifactJsonGenerator
extends AbstractDefaultValuesMuleArtifactJsonGenerator {
    public static final String EXPORTED_PACKAGES = "exportedPackages";
    public static final String EXPORTED_RESOURCES = "exportedResources";
    public static final String DEFAULT_PACKAGE_EXPORT = "";
    public static final String COMPILED_JAVA_EXTENSION = "class";
    public static final String PACKAGE_SEPARATOR = ".";

    @Override
    protected void setBuilderWithDefaultRequiredProduct(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        Product requiredProduct = originalMuleArtifact.getRequiredProduct();
        if (requiredProduct == null) {
            requiredProduct = Product.MULE;
            if (this.doesSomeConfigRequireEE(originalMuleArtifact, muleArtifactContentResolver) || this.anyMulePluginInDependenciesRequiresEE(muleArtifactContentResolver) || this.anyProvidedDependencyRequiresEE(muleArtifactContentResolver)) {
                requiredProduct = Product.MULE_EE;
            }
        }
        builder.setRequiredProduct(requiredProduct);
    }

    private boolean anyProvidedDependencyRequiresEE(MuleArtifactContentResolver muleArtifactContentResolver) {
        return muleArtifactContentResolver.getPom().getDependencies().stream().filter(coordinates -> StringUtils.equals((String)coordinates.getScope(), (String)"provided")).anyMatch(coordinates -> coordinates.getGroupId().startsWith("com.mulesoft.mule"));
    }

    private boolean anyMulePluginInDependenciesRequiresEE(MuleArtifactContentResolver muleArtifactContentResolver) {
        return muleArtifactContentResolver.getBundleDependencies().stream().filter(dep -> dep.getDescriptor().isPlugin()).filter(dep -> dep.getScope().equals((Object)BundleScope.COMPILE)).map(BundleDependency::getBundleUri).anyMatch(this::mulePluginRequiresEE);
    }

    private boolean mulePluginRequiresEE(URI uri) {
        try {
            JarFile pluginJar = new JarFile(uri.getPath());
            JarEntry muleArtifactDescriptor = pluginJar.getJarEntry("META-INF/mule-artifact/mule-artifact.json");
            InputStream is = pluginJar.getInputStream(muleArtifactDescriptor);
            String muleArtifactJson = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            MuleApplicationModel mulePluginApplicationModel = (MuleApplicationModel)serializer.deserialize(muleArtifactJson);
            Product requiredProduct = mulePluginApplicationModel.getRequiredProduct();
            return requiredProduct != null && requiredProduct.equals((Object)Product.MULE_EE);
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean doesSomeConfigRequireEE(MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        Set configs = this.getConfigs(originalMuleArtifact, muleArtifactContentResolver).stream().map(config -> muleArtifactContentResolver.getProjectStructure().getConfigsPath().resolve((String)config)).collect(Collectors.toSet());
        return configs.stream().map(this::toDocument).anyMatch(this::containsEENamespace);
    }

    private boolean containsEENamespace(Document doc) {
        if (doc == null) {
            return false;
        }
        Element root = doc.getDocumentElement();
        if (root.getNamespaceURI() != null && root.getNamespaceURI().contains(DslConstants.EE_NAMESPACE)) {
            return true;
        }
        if (root.getAttributes() != null) {
            NamedNodeMap attributes = root.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node uri = root.getAttributes().item(i);
                if (uri.getNodeValue() == null || !uri.getNodeValue().contains(DslConstants.EE_NAMESPACE)) continue;
                return true;
            }
        }
        return false;
    }

    private Document toDocument(Path filePath) {
        DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
        try {
            return ((DocumentBuilderFactory)factory).newDocumentBuilder().parse(filePath.toFile());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return null;
        }
    }

    @Override
    protected void setBuilderWithDefaultExportedPackagesValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleArtifactLoaderDescriptor descriptorLoader = builder.getClassLoaderModelDescriptorLoader();
        Map<String, Object> attributesCopy = this.getUpdatedAttributes(descriptorLoader, EXPORTED_PACKAGES, muleArtifactContentResolver.getExportedPackages());
        builder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(descriptorLoader.getId(), attributesCopy));
    }

    @Override
    protected void setBuilderWithDefaultExportedResourcesValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor;
        if (originalMuleArtifact.getClassLoaderModelLoaderDescriptor() != null) {
            Map originalAttributes = originalMuleArtifact.getClassLoaderModelLoaderDescriptor().getAttributes();
            ArrayList<String> exportedResources = new ArrayList<String>();
            if (originalAttributes != null && originalAttributes.get(EXPORTED_RESOURCES) != null) {
                exportedResources.addAll((Collection)originalAttributes.get(EXPORTED_RESOURCES));
            } else {
                exportedResources.addAll(muleArtifactContentResolver.getExportedResources());
            }
            exportedResources.addAll(muleArtifactContentResolver.getTestExportedResources());
            Map<String, Object> attributesCopy = this.getUpdatedAttributes(originalMuleArtifact.getClassLoaderModelLoaderDescriptor(), EXPORTED_RESOURCES, new ArrayList(exportedResources));
            classLoaderModelLoaderDescriptor = new MuleArtifactLoaderDescriptor(originalMuleArtifact.getClassLoaderModelLoaderDescriptor().getId(), attributesCopy);
        } else {
            Path outputDirectory = muleArtifactContentResolver.getProjectStructure().getOutputDirectory();
            List allOutputFiles = Files.walk(outputDirectory, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).collect(Collectors.toList());
            Predicate<Path> isJavaClass = path -> FilenameUtils.getExtension((String)path.toString()).endsWith(COMPILED_JAVA_EXTENSION);
            List packagesFolders = allOutputFiles.stream().filter(isJavaClass).map(path -> {
                Path parent = outputDirectory.relativize((Path)path).getParent();
                return parent != null ? parent.toString() : DEFAULT_PACKAGE_EXPORT;
            }).map(MuleArtifactContentResolver::escapeSlashes).map(s -> s.replace("/", PACKAGE_SEPARATOR)).distinct().collect(Collectors.toList());
            List<String> muleConfigs = muleArtifactContentResolver.getConfigs();
            List resources = allOutputFiles.stream().filter(isJavaClass.negate()).map(path -> outputDirectory.relativize((Path)path)).map(Path::toString).map(MuleArtifactContentResolver::escapeSlashes).collect(Collectors.toList());
            resources.addAll(muleArtifactContentResolver.getTestExportedResources());
            classLoaderModelLoaderDescriptor = new MuleArtifactLoaderDescriptorBuilder().setId("mule").addProperty(EXPORTED_PACKAGES, packagesFolders).addProperty(EXPORTED_RESOURCES, resources).build();
        }
        builder.withClassLoaderModelDescriptorLoader(classLoaderModelLoaderDescriptor);
    }

    @Override
    protected void setBuilderWithDefaultBundleDescriptorLoaderValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) {
        MuleArtifactLoaderDescriptor bundleDescriptorLoader = originalMuleArtifact.getBundleDescriptorLoader();
        builder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", bundleDescriptorLoader == null || bundleDescriptorLoader.getAttributes() == null ? new HashMap() : bundleDescriptorLoader.getAttributes()));
    }
}

