/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.validation.VersionUtils;

public class MulePluginsCompatibilityValidator {
    public void validate(List<ArtifactCoordinates> mulePlugins) throws ValidationException {
        for (Map.Entry<String, List<ArtifactCoordinates>> entry : this.buildDependencyMap(mulePlugins).entrySet()) {
            List<ArtifactCoordinates> dependencies = entry.getValue();
            if (dependencies.size() <= 1 || this.areMulePluginVersionCompatible(dependencies)) continue;
            throw new ValidationException(this.createErrorMessage(entry.getKey(), dependencies));
        }
    }

    protected boolean areMulePluginVersionCompatible(List<ArtifactCoordinates> dependencies) {
        Set majors = dependencies.stream().map(ArtifactCoordinates::getVersion).map(VersionUtils::getMajor).collect(Collectors.toSet());
        return majors.size() <= 1;
    }

    protected String createErrorMessage(String mulePlugin, List<ArtifactCoordinates> dependencies) {
        StringBuilder message = new StringBuilder().append("There are incompatible versions of the same mule plugin in the application dependency graph.").append("This application can not be packaged as it will fail to deploy.").append("Offending mule plugin: ").append(mulePlugin).append("Versions: ");
        dependencies.forEach(d -> message.append(d.getVersion()).append(","));
        return message.toString();
    }

    protected Map<String, List<ArtifactCoordinates>> buildDependencyMap(List<ArtifactCoordinates> dependencyList) {
        HashMap<String, List<ArtifactCoordinates>> dependencyMap = new HashMap<String, List<ArtifactCoordinates>>();
        for (ArtifactCoordinates plugin : dependencyList) {
            String key = plugin.getGroupId() + ":" + plugin.getArtifactId();
            dependencyMap.computeIfAbsent(key, k -> new ArrayList());
            ((List)dependencyMap.get(key)).add(plugin);
        }
        return dependencyMap;
    }
}

