/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.builder;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.archiver.ArchiverException;
import org.mule.tools.api.packager.archiver.MuleArchiver;
import org.mule.tools.api.packager.builder.PackageBuilder;
import org.mule.tools.api.packager.packaging.PackagingOptions;
import org.mule.tools.api.packager.structure.FolderNames;

public class MulePackageBuilder
implements PackageBuilder {
    public static final String CLASSLOADER_MODEL_JSON = "classloader-model.json";
    private PackagingOptions packagingOptions;
    private File classesFolder = null;
    private File testClassesFolder = null;
    private File testMule = null;
    private File repositoryFolder = null;
    private File mavenFolder = null;
    private File muleSrcFolder = null;
    private File muleArtifactFolder = null;
    protected List<File> rootResources = new ArrayList<File>();
    private MuleArchiver archiver = null;

    public MulePackageBuilder withClasses(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        Preconditions.checkArgument((boolean)folder.exists(), (Object)"The folder must exists");
        this.classesFolder = folder;
        return this;
    }

    public MulePackageBuilder withTestClasses(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        Preconditions.checkArgument((boolean)folder.exists(), (Object)"The folder must exists");
        this.testClassesFolder = folder;
        return this;
    }

    public MulePackageBuilder withTestMule(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        Preconditions.checkArgument((boolean)folder.exists(), (Object)"The folder must exists");
        this.testMule = folder;
        return this;
    }

    public MulePackageBuilder withMaven(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        Preconditions.checkArgument((boolean)folder.exists(), (Object)"The folder must exists");
        this.mavenFolder = folder;
        return this;
    }

    public MulePackageBuilder withMuleSrc(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        Preconditions.checkArgument((boolean)folder.exists(), (Object)"The folder must exists");
        this.muleSrcFolder = folder;
        return this;
    }

    public MulePackageBuilder withMuleArtifact(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        Preconditions.checkArgument((boolean)folder.exists(), (Object)"The folder must exists");
        this.muleArtifactFolder = folder;
        return this;
    }

    public MulePackageBuilder withRepository(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        Preconditions.checkArgument((boolean)folder.exists(), (Object)"The folder must exists");
        this.repositoryFolder = folder;
        return this;
    }

    public MulePackageBuilder withRootResource(File resource) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"The resource must not be null");
        Preconditions.checkArgument((boolean)resource.exists(), (Object)"The resource must exists");
        this.rootResources.add(resource);
        return this;
    }

    public MulePackageBuilder withPackagingOptions(PackagingOptions packagingOptions) {
        Preconditions.checkArgument((packagingOptions != null ? 1 : 0) != 0, (Object)"The PackagingOptions must not be null");
        this.packagingOptions = packagingOptions;
        return this;
    }

    public MulePackageBuilder withArchiver(MuleArchiver archiver) {
        Preconditions.checkArgument((archiver != null ? 1 : 0) != 0, (Object)"The archiver must not be null");
        this.archiver = archiver;
        return this;
    }

    @Override
    public void createPackage(Path originFolderPath, Path destinationPath) throws ArchiverException, IOException {
        Preconditions.checkArgument((originFolderPath != null ? 1 : 0) != 0, (Object)"The origin path must not be null");
        Preconditions.checkArgument((boolean)originFolderPath.toFile().exists(), (Object)"The origin path must exists");
        Path metaInfPath = originFolderPath.resolve(FolderNames.META_INF.value());
        this.withClasses(originFolderPath.resolve(FolderNames.CLASSES.value()).toFile()).withMaven(metaInfPath.resolve(FolderNames.MAVEN.value()).toFile()).withMuleArtifact(metaInfPath.resolve(FolderNames.MULE_ARTIFACT.value()).toFile()).withTestClasses(originFolderPath.resolve(FolderNames.TEST_CLASSES.value()).toFile()).withTestMule(originFolderPath.resolve(FolderNames.TEST_MULE.value()).resolve(FolderNames.MUNIT.value()).toFile()).withRepository(originFolderPath.resolve(FolderNames.REPOSITORY.value()).toFile()).withMuleSrc(metaInfPath.resolve(FolderNames.MULE_SRC.value()).toFile());
        this.createArchive(destinationPath);
    }

    @Override
    public void createPackage(Path destinationPath) throws ArchiverException, IOException {
        this.createArchive(destinationPath);
    }

    private void createArchive(Path destinationPath) throws IOException {
        Preconditions.checkArgument((destinationPath != null ? 1 : 0) != 0, (Object)"The destination path must not be null");
        Preconditions.checkArgument((!destinationPath.toFile().exists() ? 1 : 0) != 0, (Object)"The destination file must not be duplicated");
        this.validateState(this.packagingOptions);
        MuleArchiver archiver = this.getArchiver();
        if (!this.packagingOptions.isOnlyMuleSources()) {
            archiver.addToRoot(this.classesFolder, null, null);
            archiver.addMaven(this.mavenFolder, null, null);
            if (this.packagingOptions.isLightweightPackage() && !this.packagingOptions.isUseLocalRepository()) {
                archiver.addMuleArtifact(this.muleArtifactFolder, null, new String[]{CLASSLOADER_MODEL_JSON});
            } else {
                archiver.addMuleArtifact(this.muleArtifactFolder, null, null);
            }
            if (this.packagingOptions.isTestPackage()) {
                archiver.addToRoot(this.testClassesFolder, null, null);
                archiver.addToRoot(this.testMule, null, null);
            }
            if (!this.packagingOptions.isLightweightPackage()) {
                archiver.addRepository(this.repositoryFolder, null, null);
            }
            if (this.packagingOptions.isAttachMuleSources()) {
                archiver.addMuleSrc(this.muleSrcFolder, null, null);
            }
        } else {
            archiver.addMuleSrc(this.muleSrcFolder, null, null);
        }
        archiver.setDestFile(destinationPath.toFile());
        archiver.createArchive();
    }

    private void validateState(PackagingOptions packagingOptions) {
        Preconditions.checkState((packagingOptions != null ? 1 : 0) != 0, (Object)"Packaging options should not be null when creating a mule package");
        if (!packagingOptions.isOnlyMuleSources()) {
            this.isValidFolder(this.classesFolder, "The classes folder has not been defined");
            this.isValidFolder(this.mavenFolder, "The maven folder has not been defined");
            this.isValidFolder(this.muleArtifactFolder, "The mule-artifact folder has not been defined");
            if (packagingOptions.isTestPackage()) {
                this.isValidFolder(this.testClassesFolder, "The test-classes folder has not been defined");
                this.isValidFolder(this.testMule, "The test-mule folder has not been defined");
            }
            if (!packagingOptions.isLightweightPackage()) {
                this.isValidFolder(this.repositoryFolder, "The repository folder has not been defined");
            }
            if (packagingOptions.isAttachMuleSources()) {
                this.isValidFolder(this.muleSrcFolder, "The mules-src folder has not been defined");
            }
        } else {
            this.isValidFolder(this.muleSrcFolder, "The mules-src folder has not been defined");
        }
    }

    private void isValidFolder(File file, String message) {
        Preconditions.checkState((file != null && file.exists() && file.isDirectory() ? 1 : 0) != 0, (Object)message);
    }

    protected MuleArchiver getArchiver() {
        if (this.archiver == null) {
            this.archiver = new MuleArchiver();
        }
        return this.archiver;
    }
}

