/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation;

import java.util.ArrayList;
import java.util.List;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.validation.DependencyValidator;

public class TestScopeDependencyValidator
implements DependencyValidator {
    private List<Dependency> expectedDependencies;
    private List<String> expectedGroupIds;

    public TestScopeDependencyValidator(List<Dependency> expectedDependencies, List<String> expectedGroupIds) {
        this.expectedDependencies = expectedDependencies;
        this.expectedGroupIds = expectedGroupIds;
    }

    @Override
    public boolean areDependenciesValid(List<ArtifactCoordinates> dependencies) throws ValidationException {
        ArrayList<String> invalidDependenciesExceptionsMessages = new ArrayList<String>();
        for (ArtifactCoordinates dependency : dependencies) {
            try {
                this.isValid(dependency);
            }
            catch (ValidationException e) {
                invalidDependenciesExceptionsMessages.add(e.getMessage());
            }
        }
        if (!invalidDependenciesExceptionsMessages.isEmpty()) {
            StringBuilder invalidDependenciesMessage = new StringBuilder();
            invalidDependenciesExceptionsMessages.forEach(d -> invalidDependenciesMessage.append((String)d).append(System.lineSeparator()));
            throw new ValidationException("The following dependencies are not allowed unless their scope is [test]: " + System.lineSeparator() + invalidDependenciesMessage.toString());
        }
        return true;
    }

    private boolean isValid(ArtifactCoordinates dependency) throws ValidationException {
        boolean isGroupOrDependencyPresent;
        boolean bl = isGroupOrDependencyPresent = this.expectedGroupIds.contains(dependency.getGroupId()) || this.expectedDependencies.stream().anyMatch(d -> ((Dependency)d).artifactId.equals(dependency.getArtifactId()) && ((Dependency)d).groupId.equals(dependency.getGroupId()));
        if (isGroupOrDependencyPresent && !"test".equals(dependency.getScope())) {
            throw new ValidationException("Dependency: " + dependency + " should have scope 'test', found '" + dependency.getScope() + "'");
        }
        return true;
    }

    public static final class Dependency {
        private final String groupId;
        private final String artifactId;

        public Dependency(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }
    }
}

