/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation.resolver.model;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.exception.ProjectBuildingException;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.util.Project;
import org.mule.tools.api.util.ProjectBuilder;
import org.mule.tools.api.validation.VersionUtils;
import org.mule.tools.api.validation.resolver.model.DependenciesFilter;
import org.mule.tools.api.validation.resolver.visitor.DependencyNodeVisitor;

public class ProjectDependencyNode {
    private final Project project;
    private final ProjectBuilder builder;

    public ProjectDependencyNode(Project project, ProjectBuilder builder) {
        this.project = project;
        this.builder = builder;
    }

    public void accept(DependencyNodeVisitor visitor) throws ValidationException {
        visitor.visit(this);
    }

    public Project getProject() {
        return this.project;
    }

    public Set<ProjectDependencyNode> getChildren(DependenciesFilter filter) throws ValidationException {
        HashSet children = Sets.newHashSet();
        for (ArtifactCoordinates dependency : this.getDependencies(filter)) {
            if (VersionUtils.isRange(dependency.getVersion())) continue;
            children.add(this.buildNode(dependency));
        }
        return children;
    }

    public Set<ArtifactCoordinates> getDependencies(DependenciesFilter filter) {
        return filter.filter(this);
    }

    public ProjectDependencyNode buildNode(ArtifactCoordinates dependency) throws ValidationException {
        try {
            Project project = this.builder.buildProject(dependency);
            return new ProjectDependencyNode(project, this.builder);
        }
        catch (ProjectBuildingException e) {
            throw new ValidationException(e);
        }
    }
}

