/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.sources;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.tools.api.packager.Pom;
import org.mule.tools.api.packager.structure.ProjectStructure;
import org.mule.tools.api.util.XmlFactoryUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MuleArtifactContentResolver {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = XmlFactoryUtils.createSecureDocumentBuilderFactory();
    private static final String CONFIG_FILE_EXTENSION = ".xml";
    public static final String CLASS_PATH_SEPARATOR = "/";
    private final ProjectStructure projectStructure;
    private List<String> configs;
    private List<String> testConfigs;
    private List<String> exportedPackages;
    private List<String> exportedResources;
    private List<String> testExportedResources;
    private Boolean isApplication;
    private final Pom pom;
    private final List<BundleDependency> bundleDependencies;

    public MuleArtifactContentResolver(ProjectStructure projectStructure, Pom pom, List<BundleDependency> bundleDependencies) {
        Preconditions.checkArgument((projectStructure != null ? 1 : 0) != 0, (Object)"Project structure should not be null");
        Preconditions.checkArgument((pom != null ? 1 : 0) != 0, (Object)"Pom should not be null");
        this.projectStructure = projectStructure;
        this.pom = pom;
        this.bundleDependencies = bundleDependencies;
    }

    public ProjectStructure getProjectStructure() {
        return this.projectStructure;
    }

    public List<String> getExportedPackages() throws IOException {
        if (this.exportedPackages == null) {
            this.exportedPackages = this.getResources(this.projectStructure.getExportedPackagesPath());
        }
        return this.exportedPackages;
    }

    public List<String> getExportedResources() throws IOException {
        if (this.exportedResources == null) {
            this.exportedResources = new ArrayList<String>();
            for (Path resourcePath : this.pom.getResourcesLocation()) {
                this.exportedResources.addAll(this.getResources(resourcePath));
            }
            if (this.pom.getResourcesLocation().stream().noneMatch(path -> path.endsWith(Paths.get("src", "main", "mule")))) {
                this.exportedResources.addAll(this.getResources(this.projectStructure.getConfigsPath()));
            }
        }
        return this.exportedResources;
    }

    public List<String> getTestExportedResources() throws IOException {
        if (this.testExportedResources == null) {
            Optional<Path> testExportedResourcesPath = this.projectStructure.getTestExportedResourcesPath();
            this.testExportedResources = testExportedResourcesPath.isPresent() ? this.getResources(testExportedResourcesPath.get()) : Collections.emptyList();
        }
        return this.testExportedResources;
    }

    public List<String> getConfigs() throws IOException {
        if (this.configs == null) {
            this.configs = this.getMuleResources(this.projectStructure.getConfigsPath());
        }
        return this.configs;
    }

    public boolean isApplication() throws IOException {
        if (this.isApplication == null) {
            this.isApplication = this.getResourcesWithDocument(this.projectStructure.getConfigsPath(), this.getConfigs()).entrySet().stream().noneMatch(entry -> this.hasMuleDomainAsRootElement((Document)entry.getValue()));
        }
        return this.isApplication;
    }

    protected boolean hasMuleAsRootElement(Path path) {
        try {
            return this.hasMuleAsRootElement(DOCUMENT_BUILDER_FACTORY.newDocumentBuilder().parse(path.toFile()));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean hasMuleAsRootElement(Document doc) {
        return this.hasMuleAppAsRootElement(doc) || this.hasMuleDomainAsRootElement(doc);
    }

    protected boolean hasMuleAppAsRootElement(Document doc) {
        return this.hasTagNameAsRootElement(doc, "mule");
    }

    protected boolean hasMuleDomainAsRootElement(Document doc) {
        return this.hasTagNameAsRootElement(doc, "mule-domain") || this.hasTagNameAsRootElement(doc, "domain:mule-domain");
    }

    protected boolean hasTagNameAsRootElement(Document doc, String tagName) {
        return Optional.ofNullable(doc).map(Document::getDocumentElement).map(Element::getTagName).map(tag -> StringUtils.equals((CharSequence)tag, (CharSequence)tagName)).orElse(false);
    }

    private List<String> getMuleResources(Path path) {
        try {
            return this.getResourcesWithDocument(path, this.getResources(path, (IOFileFilter)new SuffixFileFilter(CONFIG_FILE_EXTENSION))).entrySet().stream().filter(entry -> this.hasMuleAsRootElement((Document)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public List<String> getTestConfigs() {
        if (this.testConfigs == null) {
            this.testConfigs = this.projectStructure.getTestConfigsPath().map(this::getMuleResources).orElseGet(Collections::emptyList);
        }
        return this.testConfigs;
    }

    private List<String> getResources(Path resourcesFolderPath) throws IOException {
        return this.getResources(resourcesFolderPath, TrueFileFilter.INSTANCE);
    }

    private Map<String, Document> getResourcesWithDocument(Path path, Collection<String> resources) {
        return resources.stream().collect(Collectors.toMap(Function.identity(), resource -> {
            try {
                return DOCUMENT_BUILDER_FACTORY.newDocumentBuilder().parse(path.resolve((String)resource).toFile());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }));
    }

    private List<String> getResources(Path resourcesFolderPath, IOFileFilter fileFilter) throws IOException {
        if (resourcesFolderPath == null) {
            throw new IOException("The resources folder is invalid");
        }
        File resourcesFolder = resourcesFolderPath.toFile();
        if (!resourcesFolder.exists()) {
            return new ArrayList<String>();
        }
        Collection resourcesFolderContent = FileUtils.listFiles((File)resourcesFolder, (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
        return resourcesFolderContent.stream().filter(f -> !f.isHidden()).map(File::toPath).map(p -> resourcesFolder.toPath().relativize((Path)p)).map(Path::toString).map(MuleArtifactContentResolver::escapeSlashes).collect(Collectors.toList());
    }

    public static String escapeSlashes(String p) {
        return p.replace("\\", CLASS_PATH_SEPARATOR);
    }

    public List<BundleDependency> getBundleDependencies() {
        return this.bundleDependencies;
    }

    public Pom getPom() {
        return this.pom;
    }
}

